/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.dog.service.RestDogSemenChangeService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

@Api(value = "精子变更-xuxue", tags = { "精子变更-xuxue" })
@Controller
@RequestMapping(value = "/api/v1/dog/dogSemenChange")
public class RestDogSemenChangeController extends BaseRestController {

	@Autowired
	private RestDogSemenChangeService restDogSemenChangeService;

	@ApiOperation(value = "精子变更-我的申请/审核详情页", notes = "入参： 精子变更主体ID")
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + "	\"rc\": 0,\n" + "	\"msg\": \"OK\",\n"
			+ "	\"data\": {\n" + "                \"id\": \"205afb465c424108bd1dbee54009644d\",-- 精子变更主体ID\n"
			+ "		\"dogId\": \"b9ca85c141124988a888a95108406bf9\",\n"
			+ "		\"pedigreeCertified\": \"CKU-111463176/20\",  --  血统证书号\n"
			+ "		\"dogChip\": \"100000202005253\", -- 芯片号\n" + "		\"dogBreed\": \"金毛寻回猎犬\",-- 犬种\n"
			+ "		\"dogName\": \"hedhh Xamie\",--名字\n" + "		\"dogOwner\": \"刘载春\",-- 犬主\n"
			+ "		\"originMemberCode\": \"2268\",-- 精子原主人会员号\n" + "		\"originMemberName\": \"刘载春\",-- 精子原主人会员\n"
			+ "		\"newMemberCode\": \"6431\",-- 精子新主人会员号\n" + "		\"newMemberName\": \"张瀚文\",-- 精子新主人会员\n"
			+ "		\"createDate\": \"2020-05-25\", -- 创建日期\n" + "		\"businessState\": \"待审核\", -- 审核状态\n"
			+ "		\"reviewState\": \"0\",  --  审核状态 0未审核 1原主人通过 2原主人不通过\n" + "		\"reviewRemarks\": \"\",\n"
			+ "		\"dogSemenList\": [{\n" + "			\"id\": \"f436eda05d4d4580a92785f167ef388b\",\n"
			+ "			\"originalSemenCode\": \"123455647\",  -- 原精子编号\n"
			+ "			\"semenCode\": \"JZ000002310\" -- cku精子编号 \n" + "		}],\n"
			+ "		\"semenNumber\": 1-- 精子数量\n" + "	}\n" + "}\n" + ""))
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	public void get(@PathVariable("id") String id, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogSemenChangeService.get(id);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "精子变更-我的申请/审核", notes = "入参：\n" + "type  new我的申请  origin我的审核\n" + "pedigreeCertified 血统证书号\n"
			+ "originMemberCode 原会员号\n" + "semenCode  CKU精子编号\n" + "pageSize 页面大小\n" + "pageNo 页码\n" + "")
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + "	\"rc\": 0,\n" + "	\"msg\": \"OK\",\n"
			+ "	\"list\": [{\n" + "		\"id\": \"205afb465c424108bd1dbee54009644d\",-- 精子变更主体ID\n"
			+ "		\"dogId\": \"b9ca85c141124988a888a95108406bf9\",\n"
			+ "		\"pedigreeCertified\": \"CKU-111463176/20\",  --  血统证书号\n"
			+ "		\"dogChip\": \"100000202005253\", -- 芯片号\n" + "		\"dogBreed\": \"金毛寻回猎犬\",-- 犬种\n"
			+ "		\"dogName\": \"hedhh Xamie\",--名字\n" + "		\"dogOwner\": \"刘载春\",-- 犬主\n"
			+ "		\"originMemberCode\": \"2268\",-- 精子原主人会员号\n" + "		\"originMemberName\": \"刘载春\",-- 精子原主人会员\n"
			+ "		\"newMemberCode\": \"6431\",-- 精子新主人会员号\n" + "		\"newMemberName\": \"张瀚文\",-- 精子新主人会员\n"
			+ "		\"createDate\": \"2020-05-25\", -- 创建日期\n" + "		\"businessState\": \"待审核\", -- 审核状态\n"
			+ "		\"reviewRemarks\": \"\"\n" + "	}],\n" + "	\"total\": 1\n" + "}\n" + ""))
	@RequestMapping(value = "", method = RequestMethod.GET)
	public void getList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogSemenChangeService.getList(request);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "精子变更-提交变更", notes = "入参：\n"
			+ "{\"dogSemenId\":[\"a884a36f75064c1a96d0fd45b479019e\"]}-- 精子实体ID\n" + "")
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + "    \"rc\": 0,\n" + "    \"msg\": \"OK\",\n"
			+ "    \"data\": \"5425297c9708482fb7480c393a97a37f\" -- 购物车条目ID\n" + "}\n" + ""))
	@RequestMapping(value = "", method = RequestMethod.POST)
	public void post(@RequestBody String json, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogSemenChangeService.post(json);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "精子变更-原主人提交审核", notes = "入参： \n" + "{\n"
			+ "	\"id\": \"8646b6a49d7c4e4eafcae384933fc81a\",  -- 变更记录ID\n"
			+ "	\"reviewState\": \"1\",  -- 1同意  2 不同意\n" + "	\"reviewRemarks\": \"\" \n" + "}\n" + "")
	@ApiResponses(@ApiResponse(code = 200, message = "{\"rc\":0,\"msg\":\"OK\"}"))
	@RequestMapping(value = "", method = RequestMethod.PUT)
	public void put(@RequestBody String json, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogSemenChangeService.put(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/getPrice", method = RequestMethod.GET)
	public void getPrice(HttpServletResponse response) throws IOException {
		RESTResponse result = restDogSemenChangeService.getPrice();
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * @Description：根据血统证书号查询犬只可用精子
	 * @author: zhuoHeng
	 * @version: 2017年1月5日 下午3:56:43
	 */
	@ApiOperation(value = "精子变更-查询", notes = "入参：\n" + "pedigreeCertified 血统证书号\n" + "memberCode 原会员号\n" + "")
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + "	\"rc\": 0,\n" + "	\"msg\": \"OK\",\n"
			+ "	\"data\": {\n" + "		\"dogId\": \"b9ca85c141124988a888a95108406bf9\", \n"
			+ "		\"pedigreeCertified\": \"CKU-111463176/20\",-- 血统证书号\n"
			+ "		\"dogChip\": \"100000202005253\",--芯片号\n" + "		\"dogBreed\": \"金毛寻回猎犬\",--犬种\n"
			+ "		\"dogName\": \"hedhh Xamie\",-- 名字\n" + "		\"dogOwner\": \"刘载春\",--犬主\n"
			+ "		\"dogSemenList\": [{\n" + "			\"id\": \"a884a36f75064c1a96d0fd45b479019e\", -- 精子实体ID\n"
			+ "			\"originalSemenCode\": \"3让64756857\",  -- 原精子编号\n"
			+ "			\"semenCode\": \"JZ000002311\" -- cku精子编号 \n" + "		}, {\n"
			+ "			\"id\": \"f436eda05d4d4580a92785f167ef388b\",\n"
			+ "			\"originalSemenCode\": \"123455647\",  -- 原精子编号\n"
			+ "			\"semenCode\": \"JZ000002310\" -- cku精子编号 \n" + "		}],\n"
			+ "		\"dogSemenListCount\": 2, -- 精子数量\n" + "		\"msg\": \"\"\n" + "	}\n" + "}\n" + ""))
	@RequestMapping(value = "/getDogSemenByPedigreeCertifiedAndMemberCode", method = RequestMethod.GET)
	public void getDogSemenByPedigreeCertifiedAndMemberCode(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restDogSemenChangeService.getDogSemenByPedigreeCertifiedAndMemberCode(request);
		ServletUtils.writeResponse(response, result);
	}
}