package com.cku.restful.v1.dog.vo.request;

import com.cku.oa.order.vo.request.OrderBusinessRequest;
import com.drew.lang.annotations.NotNull;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

/**
 * @author yuanshuai
 * @date 2023/6/8 15:27
 */
@Data
@ApiModel
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class GoldCertifiedApplyRequest extends OrderBusinessRequest {


	private static final long serialVersionUID = -9112469684088700049L;
	@ApiModelProperty("申请来源（1:血统证书升级2:登记卡申请）")
	@NotNull
	private Integer applySource;

    @ApiModelProperty("血统证书号")
    private String pedigreeCertified;

    @ApiModelProperty("出生纸编号")
    private String birthCode;

	@ApiModelProperty("呼名")
	private String nickname;

	@ApiModelProperty("新犬主")
	private String newMemberCode;

	@ApiModelProperty(value = "电子证书标记位：0否；1是")
	@NotNull
	private Integer ecertFlag;

	@ApiModelProperty(value = "DNA办理方式：0机构办理；1自检")
	@NotNull
	private Integer dnaApplyChannel;

	@ApiModelProperty(value = "医院编号")
	private String hospitalCode;
}
