/**
 * Copyright &copy; 2012-2014 <a href="https:github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.model;

import java.io.Serializable;
import java.util.List;

import com.cku.oa.finance.entity.PaymentChargingItem;
import com.fasterxml.jackson.annotation.JsonIgnore;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

/**
 * 血统证书计算价格返回DTO
 */
@Data
@Builder
@ApiModel
public class RestDogChipPriceResultDto implements Serializable {

	private static final long serialVersionUID = 4827952673844377322L;
	
	@ApiModelProperty(value = "价格")
	private String price;
	
	@JsonIgnore
	@ApiModelProperty(value = "收费项详情",hidden = true)
	private List<PaymentChargingItem> items;

}