package com.cku.partner.club.web;

import com.cku.oa.sys.entity.BaseFile;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.FileService;
import com.cku.partner.club.service.ClubOrgService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.Area;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 合作机构、合作医院Controller
 * @author
 * @version 2016-08-22
 */
@Controller
@RequestMapping(value = "/partner/org")
public class ClubOrgController extends BaseController {

	@Autowired
	private ClubOrgService clubOrgService;
	@Autowired
	private FileService fileService;

	@RequestMapping(value = {"list", ""})
	public String list(Org org, HttpServletRequest request, HttpServletResponse response, Model model) {
		Org org2 = (Org) UserUtils.getSession().getAttribute("org");
		org.setTuijiansren(org2.getId());
		Page<Org> page = clubOrgService.findPage(new Page<Org>(request, response), org);
		model.addAttribute("page", page);
		Date currentDate = new Date();
		model.addAttribute("currentDate",currentDate);
		return "partner/org/clubOrgList";
	}

	@RequestMapping(value = "view")
	public String view(Org org, Model model) {
		Org org2 = (Org) UserUtils.getSession().getAttribute("org");
		model.addAttribute("org2", org2);
		model.addAttribute("org", clubOrgService.get(org.getId()));
		model.addAttribute("province",UserUtils.getProvince());
		model.addAttribute("city",UserUtils.getCityByProvince(org.getProvince()));
		return "partner/org/clubOrgView";
	}
	@RequestMapping(value = "form")
	public String form(Org org, Model model) {
		Org org2 = (Org) UserUtils.getSession().getAttribute("org");
		model.addAttribute("org2", org2);
		model.addAttribute("province",UserUtils.getProvince());
		model.addAttribute("city",UserUtils.getCityByProvince(org.getProvince()));
		return "partner/org/clubOrgForm";
	}
	@RequestMapping(value = "editForm")
	public String editForm(Org org, Model model) {
		Org org2 = (Org) UserUtils.getSession().getAttribute("org");
		model.addAttribute("org2", org2);
		org = clubOrgService.get(org.getId());
		model.addAttribute("org", org);
		model.addAttribute("province",UserUtils.getProvince());
		model.addAttribute("city",UserUtils.getCityByProvince(org.getProvince()));
		return "partner/org/clubOrgEditForm";
	}

	@ResponseBody
	@RequestMapping(value = "treeData")
	public List<Map<String, Object>> treeData(@RequestParam(required=false) String extId, HttpServletResponse response) {
		List<Map<String, Object>> mapList = Lists.newArrayList();
		extId = URLDecoder.decode(extId);
		List<Area> list = UserUtils.getCityByProvince(extId);
		for (int i=0; i<list.size(); i++){
			Area e = list.get(i);
			Map<String, Object> map = Maps.newHashMap();
			map.put("id", e.getId());
			map.put("pId", e.getParentId());
			map.put("name", e.getName());
			mapList.add(map);
		}
		return mapList;
	}

	@RequestMapping(value="layupload")
	@ResponseBody
	public void layupload(@RequestParam MultipartFile file, HttpServletRequest request, HttpServletResponse response) throws IOException
	{
		BaseFile baseFile = fileService.uploadFile(file,"ShowPic","1");

		JSONObject fileObject = new JSONObject();
		fileObject.put("id", baseFile.getId());
		fileObject.put("fileName", baseFile.getName());
		fileObject.put("realName", baseFile.getOrginalname());
		String path = request.getContextPath();
		String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/open/image/"+baseFile.getId();
		fileObject.put("url", imgPath);
		response.setContentType("text/html;charset=UTF-8");//ie 浏览器使用layui 需设置头为html
		response.getWriter().write(fileObject.toString());
	}
	@RequestMapping(value = "save")
	public String save(Org org, Model model, RedirectAttributes redirectAttributes) {
		try {
			clubOrgService.saveClubOrg(org);
			addMessage(redirectAttributes, "保存成功");
		} catch (Exception e) {
			logger.warn("门店保存失败",e);
			addMessage(redirectAttributes, "门店保存失败:"+e.getMessage());
		}
		return "redirect:/partner/org/list?repage";
	}

	@RequestMapping(value = "delete")
	public String delete(Org org, RedirectAttributes redirectAttributes) {
		clubOrgService.delete(org);
		addMessage(redirectAttributes, "删除合作机构、合作医院成功");
		return "redirect:/partner/org/list?repage";
	}

}