/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 计划任务管理Entity
 * @author zhuoHeng
 * @version 2017-03-29
 */
public class TaskTrigger extends DataEntity<TaskTrigger> {
	
	private static final long serialVersionUID = 1L;
	private String jobInfo;		// 工作计划描述
	private String jobName;		// 工作计划名称
	private String jobGroup;		// 任务组名
	private String jobCls;		// 任务执行类名
	private String timeFormat;		// 触发时间格式
	private Date lastExecuteTime;		// 最后执行时间
	private String state;		// 当前状态
	private String executeState; // 执行状态
	
	public TaskTrigger() {
		super();
	}

	public TaskTrigger(String id){
		super(id);
	}

	@Length(min=0, max=255, message="工作计划描述长度必须介于 0 和 255 之间")
	public String getJobInfo() {
		return jobInfo;
	}

	public void setJobInfo(String jobInfo) {
		this.jobInfo = jobInfo;
	}
	
	@Length(min=0, max=64, message="工作计划名称长度必须介于 0 和 64 之间")
	public String getJobName() {
		return jobName;
	}

	public void setJobName(String jobName) {
		this.jobName = jobName;
	}
	
	@Length(min=0, max=50, message="任务组名长度必须介于 0 和 50 之间")
	public String getJobGroup() {
		return jobGroup;
	}

	public void setJobGroup(String jobGroup) {
		this.jobGroup = jobGroup;
	}
	
	@Length(min=0, max=100, message="任务执行类名长度必须介于 0 和 100 之间")
	public String getJobCls() {
		return jobCls;
	}

	public void setJobCls(String jobCls) {
		this.jobCls = jobCls;
	}
	
	@Length(min=0, max=64, message="触发时间格式长度必须介于 0 和 64 之间")
	public String getTimeFormat() {
		return timeFormat;
	}

	public void setTimeFormat(String timeFormat) {
		this.timeFormat = timeFormat;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getLastExecuteTime() {
		return lastExecuteTime;
	}

	public void setLastExecuteTime(Date lastExecuteTime) {
		this.lastExecuteTime = lastExecuteTime;
	}
	
	@Length(min=0, max=100, message="当前状态长度必须介于 0 和 100 之间")
	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getExecuteState() {
		return executeState;
	}

	public void setExecuteState(String executeState) {
		this.executeState = executeState;
	}
	
	
}