/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 芯片发放记录Entity
 * @author fanhuibin
 * @version 2016-09-06
 */
public class OrgChip extends DataEntity<OrgChip> {
	
	private static final long serialVersionUID = 1L;
	private Date postDate;		// 发放日期
	private String chipCode;		// 芯片号
	private String address;		// 地址
	private String orgId;		// 合作机构id
	private String invalid;		// 是否作废
	private String bloodCard;		// 采血卡数量
	private String drawBlood;		// 采血器材
	private String pedigreeCertified;		// 血统证书
	private String pedigreeCertifiedMc;		// 玛犬血统证书
	private String pedigreeCertifiedDc;		// 杜高血统证书
	private String appraisalCertified;		// 鉴定证书
	private String dnaPedigreeCertified;		// DNA血统证书证书
	private String dnaBreedCertified;		// DNA繁育证书证书
	private int count;
	private Org org;
	private String birthCerRegCode; //出生证明编号
	//前端录入用
	private String chipPrefix; //芯片前缀

	public String getBirthCerRegCode() {
		return birthCerRegCode;
	}

	public void setBirthCerRegCode(String birthCerRegCode) {
		this.birthCerRegCode = birthCerRegCode;
	}

	public Org getOrg() {
		return org;
	}

	public void setOrg(Org org) {
		this.org = org;
	}

	public int getCount() {
		return count;
	}

	public void setCount(int count) {
		this.count = count;
	}

	public OrgChip() {
		super();
	}

	public OrgChip(String id){
		super(id);
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@NotNull(message="发放日期不能为空")
	public Date getPostDate() {
		return postDate;
	}

	public void setPostDate(Date postDate) {
		this.postDate = postDate;
	}
	
	@Length(min=0, max=50, message="芯片号长度必须介于 0 和 50 之间")
	public String getChipCode() {
		return chipCode;
	}

	public void setChipCode(String chipCode) {
		this.chipCode = chipCode;
	}
	
	@Length(min=0, max=100, message="地址长度必须介于 0 和 100 之间")
	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}
	
	@Length(min=1, max=64, message="合作机构id长度必须介于 1 和 64 之间")
	public String getOrgId() {
		return orgId;
	}

	public void setOrgId(String orgId) {
		this.orgId = orgId;
	}
	
	@Length(min=1, max=2, message="是否作废长度必须介于 1 和 2 之间")
	public String getInvalid() {
		return invalid;
	}

	public void setInvalid(String invalid) {
		this.invalid = invalid;
	}

	public String getBloodCard() {
		return bloodCard;
	}

	public void setBloodCard(String bloodCard) {
		this.bloodCard = bloodCard;
	}

	public String getDrawBlood() {
		return drawBlood;
	}

	public void setDrawBlood(String drawBlood) {
		this.drawBlood = drawBlood;
	}

	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}

	public String getPedigreeCertifiedMc() {
		return pedigreeCertifiedMc;
	}

	public void setPedigreeCertifiedMc(String pedigreeCertifiedMc) {
		this.pedigreeCertifiedMc = pedigreeCertifiedMc;
	}

	public String getPedigreeCertifiedDc() {
		return pedigreeCertifiedDc;
	}

	public void setPedigreeCertifiedDc(String pedigreeCertifiedDc) {
		this.pedigreeCertifiedDc = pedigreeCertifiedDc;
	}

	public String getAppraisalCertified() {
		return appraisalCertified;
	}

	public void setAppraisalCertified(String appraisalCertified) {
		this.appraisalCertified = appraisalCertified;
	}

	public String getDnaPedigreeCertified() {
		return dnaPedigreeCertified;
	}

	public void setDnaPedigreeCertified(String dnaPedigreeCertified) {
		this.dnaPedigreeCertified = dnaPedigreeCertified;
	}

	public String getDnaBreedCertified() {
		return dnaBreedCertified;
	}

	public void setDnaBreedCertified(String dnaBreedCertified) {
		this.dnaBreedCertified = dnaBreedCertified;
	}

	public String getChipPrefix() {
		return chipPrefix;
	}

	public void setChipPrefix(String chipPrefix) {
		this.chipPrefix = chipPrefix;
	}
}