package com.cku.oa.statistics.web;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cku.oa.statistics.dao.HospitalStatisticsDao;
import com.thinkgem.jeesite.common.persistence.Page;

/**
 * 合作医院统计
 *user chaixueteng
 *2016年12月19日
 */
@Controller
@RequestMapping(value = "${adminPath}/statistics/hospital")
public class HospitalStatisticsController {
	
	@Autowired
	public HospitalStatisticsDao hospitalStatisticsDao;
	
	/**
	 * 商城销售统计
	 * @throws ParseException 
	 */
	
	@RequestMapping(value = "hospitalStatistics")
	public String shopStatistics(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException{
			String startDate = request.getParameter("startDate");
			String endDate = request.getParameter("endDate");
			String name=request.getParameter("name");
			String state=request.getParameter("state");
			String nowDate=request.getParameter("nowDate");
			String area = request.getParameter("area");
			if(area!=null&&area.equals("all")){
				area=null;
			}
			if(state==null)
			{
				state="0";
			}
			if(nowDate==null)
			{
				nowDate="";
			}
			Calendar cal = Calendar.getInstance();
			int year = cal.get(Calendar.YEAR);
			int month = cal.get(Calendar.MONTH )+1;
			int day = cal.get(Calendar.DAY_OF_MONTH);
			if(!nowDate.equals(""))
			{
				if(nowDate.equals("year"))
				{
					startDate = String.valueOf(year)+"-01-01 00:00:00";
					endDate = String.valueOf(year)+"-12-31 23:59:59";
				}else if(nowDate.equals("month")){
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-01 00:00:00";
					endDate = String.valueOf(year)+"-"+String.valueOf(month+1)+"-01 23:59:59";
				}
			}else{
				if(startDate == null || startDate.equals(""))
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
				if(endDate == null || endDate.equals(""))
					endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
			}
			
			//统计商品每个品种的销售信息
			List<Map> results = hospitalStatisticsDao.countByDate(startDate,endDate,name,state,area);
			//往页面传值
			model.addAttribute("results",results);			
			model.addAttribute("size",results.size());			
			model.addAttribute("startDate",startDate);
			model.addAttribute("endDate",endDate);
			model.addAttribute("name",name);
			model.addAttribute("state",state);
			model.addAttribute("date",new Date());
			model.addAttribute("area", area);
			Page<Object> page = new Page<Object>(request, response);//从页面的参数中获取当前的页码等信息
			 //你这个功能根本不需要分页，我就不给你差总条数了，自己看着办吧。
			page.setCount(results.size());
			page.initialize();//重新计算页码信息
			model.addAttribute("page",page);
			return "oa/statistics/org/hospitalStatistics";	
	}
}
