package com.cku.oa.statistics.strategy;

import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.statistics.entity.SaPaymentDetail;
import com.cku.oa.statistics.service.SaPaymentDetailService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SplitOneToManyStrategy implements InitSplitStrategy{
    private SaPaymentDetailService saPaymentDetailService;
    private HashMap<String,RelationShipEntity> relationShipMap;
    private HashMap<String,BigDecimal> chargingPriceMap;

    public SplitOneToManyStrategy(SaPaymentDetailService saPaymentDetailService,HashMap<String,RelationShipEntity> relationShipMap,HashMap<String,BigDecimal> chargingPriceMap) {

        this.saPaymentDetailService = saPaymentDetailService;
        this.relationShipMap =relationShipMap;
        this.chargingPriceMap = chargingPriceMap;
    }

    /**
     * 旧账到新张 不变平移方法且只有一个对应项 订单详细表
     */
    @Override
    public void initSplitOrderDetail(List<PaymentOrderDetail> orderDetailList , String id) {
        RelationShipEntity relationShipEntity = relationShipMap.get(id);
        orderDetailList.forEach( r ->{
            List<String> insertCharging = new ArrayList<String>();
            List<BigDecimal> insertPrice = new ArrayList<BigDecimal>();
            //新规实际收款价格
            List<BigDecimal> insertPay = new ArrayList<BigDecimal>();
            BigDecimal chargingPrice = new BigDecimal(0);
            if(relationShipEntity.getCku()!=null && relationShipEntity.getCku().length()>0){
                String[] ckuArr = relationShipEntity.getCku().split(",");
                for(String cku : ckuArr){
                    insertCharging.add(cku);
                    insertPrice.add( chargingPriceMap.get(cku));
                    insertPay.add(chargingPriceMap.get(cku));
                    chargingPrice = chargingPrice.add(chargingPriceMap.get(cku));

                }

            }
            if(relationShipEntity.getCab()!=null && relationShipEntity.getCab().length()>0){
                String[] cabArr = relationShipEntity.getCab().split(",");
                for(String cab: cabArr){
                    insertCharging.add(cab);
                    insertPrice.add( chargingPriceMap.get(cab));
                    insertPay.add(chargingPriceMap.get(cab));
                    chargingPrice = chargingPrice.add(chargingPriceMap.get(cab));
                }
            }
            try {
                BigDecimal realPrice = new BigDecimal(r.getTotalPrice()).divide(new BigDecimal(Integer.parseInt(r.getNum())));
                //如果不相等 eg 1 相同情况有 正常
                if(chargingPrice.compareTo(realPrice)!=0 && chargingPrice.compareTo(new BigDecimal(0))>0 && realPrice.compareTo(new BigDecimal(0))<0){
                    BigDecimal yinzi = realPrice.divide(chargingPrice,2,BigDecimal.ROUND_HALF_UP);
                    for(int i=0;i<insertPrice.size();i++){
                        insertPay.set(i,insertPrice.get(i).multiply(yinzi));
                    }
                }else if( realPrice.compareTo(new BigDecimal(0))==0){
                    for(int i=0;i<insertPrice.size();i++){
                        insertPay.set(i,new BigDecimal(0));
                    }
                }


                for(int i=0;i<insertCharging.size();i++){
                    SaPaymentDetail saDetail = new SaPaymentDetail();
                    saDetail.setPaymentNum(Integer.valueOf(r.getNum()));
                    saDetail.setMemberCode(r.getMemberCode());
                    saDetail.setChargeDate(r.getCreateDate());
                    saDetail.setRunningNumber(r.getOrderCode());
                    if(insertCharging.get(i).indexOf("cab")>-1){
                        saDetail.setType(PAYMENT_TYPE_CAB);
                    }else{
                        saDetail.setType(PAYMENT_TYPE_CKU);
                    }
                    saDetail.setSourceCharge(id);
                    saDetail.setChargeItemId(insertCharging.get(i));
                    saDetail.setPrice(insertPrice.get(i).toString());
                    saDetail.setPaymentMoney(insertPay.get(i).multiply(new BigDecimal(Integer.parseInt(r.getNum()))).toString());

                    saDetail.setRecordId(r.getId());
                    saDetail.setPaymentTime((r.getPaymentOrder()!=null &&r.getPaymentOrder().getPaymentTime()!=null)?r.getPaymentOrder().getPaymentTime():r.getAddTime());
                    saDetail.setDeptId(relationShipEntity.getDept());
                    saPaymentDetailService.save(saDetail);
                }

            } catch (Exception e) {
                System.out.println("数据处理错误：总价或者数量少"+ r.getId());
                e.printStackTrace();
            }




        });
    }
    /**
     * 一拆多情况   流水记录表
     */
    @Override
    public void initSplitRecord(List<PaymentRecord> recordList , String id) {
        RelationShipEntity relationShipEntity = relationShipMap.get(id);
        recordList.forEach( r ->{
            // 拆分的收费项列表
            List<String> insertCharging = new ArrayList<String>();
            // 新规价格
            List<BigDecimal> insertPrice = new ArrayList<BigDecimal>();
            //新规实际收款价格
            List<BigDecimal> insertPay = new ArrayList<BigDecimal>();
            //新规总价
            BigDecimal chargingPrice = new BigDecimal(0);
            if(relationShipEntity.getCku()!=null && relationShipEntity.getCku().length()>0){
                String[] ckuArr = relationShipEntity.getCku().split(",");
                for(String cku : ckuArr){
                    insertCharging.add(cku);
                    insertPrice.add( chargingPriceMap.get(cku));
                    insertPay.add(chargingPriceMap.get(cku));
                    chargingPrice = chargingPrice.add(chargingPriceMap.get(cku));

                }

            }
            if(relationShipEntity.getCab()!=null && relationShipEntity.getCab().length()>0){
                String[] cabArr = relationShipEntity.getCab().split(",");
                for(String cab: cabArr){
                    insertCharging.add(cab);
                    insertPrice.add( chargingPriceMap.get(cab));
                    insertPay.add(chargingPriceMap.get(cab));
                    chargingPrice = chargingPrice.add(chargingPriceMap.get(cab));
                }
            }


            try {
                BigDecimal realPrice = new BigDecimal(r.getPaymentAmount()).divide(new BigDecimal(r.getChargingItemNum()==null?1:r.getChargingItemNum()));

                //如果不相等 eg 1 相同情况有 正常
                if(chargingPrice.compareTo(realPrice)!=0 && chargingPrice.compareTo(new BigDecimal(0))>0 && realPrice.compareTo(new BigDecimal(0))<0){
                    BigDecimal yinzi = realPrice.divide(chargingPrice,2,BigDecimal.ROUND_HALF_UP);
                    for(int i=0;i<insertPrice.size();i++){
                        insertPay.set(i,insertPrice.get(i).multiply(yinzi));
                    }
                }else if( realPrice.compareTo(new BigDecimal(0))==0){
                    for(int i=0;i<insertPrice.size();i++){
                        insertPay.set(i,new BigDecimal(0));
                    }
                }


                for(int i=0;i<insertCharging.size();i++){
                    SaPaymentDetail saDetail = new SaPaymentDetail();
                    saDetail.setPaymentNum(r.getChargingItemNum()==null?1:Integer.valueOf(r.getChargingItemNum()));
                    saDetail.setMemberCode(r.getMemberCode());
                    saDetail.setChargeDate(r.getCreateDate());
                    saDetail.setRunningNumber(r.getRunningNumber());

                    if(insertCharging.get(i).indexOf("cab")>-1){
                        saDetail.setType(PAYMENT_TYPE_CAB);
                    }else{
                        saDetail.setType(PAYMENT_TYPE_CKU);
                    }
                    saDetail.setSourceCharge(id);
                    saDetail.setChargeItemId(insertCharging.get(i));
                    saDetail.setPrice(insertPrice.get(i).toString());
                    saDetail.setPaymentMoney(insertPay.get(i).multiply(new BigDecimal(r.getChargingItemNum()==null?1:r.getChargingItemNum())).toString());

                    saDetail.setRecordId(r.getId());
                    saDetail.setPaymentTime(r.getPaymentTime());
                    saDetail.setDeptId(relationShipEntity.getDept());
                    saPaymentDetailService.save(saDetail);
                }

            } catch (Exception e) {
                System.out.println("数据处理错误：总价或者数量少"+ r.getId());
                e.printStackTrace();
            }
        });
    }
}
