/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 报名满减优惠表Entity
 * @author xx
 * @version 2022-09-13
 */
public class ShowApplyDiscount extends DataEntity<ShowApplyDiscount> {
	
	private static final long serialVersionUID = 1L;
	private String showMainId;		// 主赛事ID
	private String showApplyId;		// 申请ID
	private String runningNumber;		// 流水号
	private String discountSign;		// 计数标志（当前为犬主人会员号）
	private String cycleSign;		// 周期标志
	private int cycleSignNo;		// 周期序号
	private String isDiscount;		// 是否减免：0减免 1不减免
	
	public ShowApplyDiscount() {
		super();
	}

	public ShowApplyDiscount(String id){
		super(id);
	}
	
	

	public int getCycleSignNo() {
		return cycleSignNo;
	}

	public void setCycleSignNo(int cycleSignNo) {
		this.cycleSignNo = cycleSignNo;
	}

	@Length(min=0, max=64, message="主赛事ID长度必须介于 0 和 64 之间")
	public String getShowMainId() {
		return showMainId;
	}

	public void setShowMainId(String showMainId) {
		this.showMainId = showMainId;
	}
	
	@Length(min=0, max=64, message="申请ID长度必须介于 0 和 64 之间")
	public String getShowApplyId() {
		return showApplyId;
	}

	public void setShowApplyId(String showApplyId) {
		this.showApplyId = showApplyId;
	}
	
	@Length(min=0, max=64, message="流水号长度必须介于 0 和 64 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}
	
	@Length(min=0, max=64, message="计数标志（当前为犬主人会员号）长度必须介于 0 和 64 之间")
	public String getDiscountSign() {
		return discountSign;
	}

	public void setDiscountSign(String discountSign) {
		this.discountSign = discountSign;
	}
	
	@Length(min=0, max=64, message="周期标志长度必须介于 0 和 64 之间")
	public String getCycleSign() {
		return cycleSign;
	}

	public void setCycleSign(String cycleSign) {
		this.cycleSign = cycleSign;
	}
	
	@Length(min=0, max=1, message="是否减免：0减免 1不减免长度必须介于 0 和 1 之间")
	public String getIsDiscount() {
		return isDiscount;
	}

	public void setIsDiscount(String isDiscount) {
		this.isDiscount = isDiscount;
	}
	
}