/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

/**
 * 赛事报名表Entity
 * @author lgl
 * @version 2016-07-15
 */
public class ShowApply extends DataEntity<ShowApply> {

	private static final long serialVersionUID = 1L;
	@ExcelField(title="报名序号", align=2, sort=24)
	private String applyCode;		// 报名序号
	private Integer showNum;  //赛事场次
	private String mainShowId;  //主赛事id
	@NotBlank
	@ExcelField(title="犬展编号", align=2, sort=1)
	private String showCode;		// 赛事编号
	private String organizer;		// 承办单位
	@ExcelField(title="犬主人", align=2, sort=3)
	private String dogOwnerNameCn;		// 犬主人姓名
	@ExcelField(title="姓名拼音", align=2, sort=4)
	private String dogOwnerNameEn;		// 犬主英文名
	@ExcelField(title="会员号", align=2, sort=5)
	private String dogOwnerMemberCode;		// 犬主人会员号
	@ExcelField(title="犬种中文名", align=2, sort=7)
	private String dogBreedNameCn;		// 犬种中文名
	@ExcelField(title="犬种英文名", align=2, sort=8)
	private String dogBreedNameEn;		// 犬种英文名
	@ExcelField(title="犬种组", align=2, sort=10)
	private String dogBreedGroup;		// 犬种组
	@ExcelField(title="犬名", align=2, sort=11)
	private String dogName;		// 犬名
	@ExcelField(title="性别", align=2, sort=12)
	private String dogGender;		// 犬性别
	@ExcelField(title="代数", align=2, sort=13)
	private String dogGeneration;		// 代数
	@ExcelField(title="出生日期", align=2, sort=14)
	private Date dogBirthday;		// 犬只出生日期
	@ExcelField(title="CKU血统证书号", align=2, sort=16)
	private String pedigreeCertified;		// 血统证书号
	@ExcelField(title="国外血统证书号", align=2, sort=17)
	private String otherCertified;		// 国外血统证书号
	@ExcelField(title="FCI码", align=2, sort=9)
	private String fciCode;		// FCI码
	@ExcelField(title="芯片号", align=2, sort=18)
	private String chipCode;		// 芯片号
	@ExcelField(title="父犬血统证书号", align=2, sort=19)
	private String fdogPedigreeCertified;		// 父血统证书号
	@ExcelField(title="父犬名", align=2, sort=20)
	private String fdogName;		// 父犬名
	@ExcelField(title="母犬血统证书号", align=2, sort=21)
	private String mdogPedigreeCertified;		// 母血统证书号
	@ExcelField(title="母犬名", align=2, sort=22)
	private String mdogName;		// 母犬名
	@ExcelField(title="繁殖人", align=2, sort=23)
	private String breeder;		// 繁殖人
	@ExcelField(title="年龄组别", align=2, sort=15)
	private String ageGroup;		// 年龄组别
	@ExcelField(title="犬主人组", align=2, sort=66)
	private String isOwner;		// 犬主人组
	private String showApplyAppraisal;		// 赛事报名鉴定
	private String fee;		// 报名费
	@ExcelField(title="实收金额", align=2, sort=26)
	private String paymentAmount;		// 实收金额
	private String paymentChargingItemId;		// 收费项id，（用于北京自办等收费项进行统计）
	private String shortName;		// 只在查询时关联payment_charging_item表中的short_name字段（用于调用收费控件）
	@ExcelField(title="报名费", align=2, sort=26)
	private String orderPrice;		// 订单金额
	@ExcelField(title="请假及取消", align=2, sort=31)
	private String refundFlag;		// 赛前退费
	@ExcelField(title="犬展活动区域请假", align=2, sort=32)
	private String absenceFlag;		// 赛场请假
	@ExcelField(title="BBE", align=2, sort=25)
	private String bbeFlag;		// BBE
	private String phoneApplyFlag;		// 电话报名标志（null:不是电话报名;0:未交服务费；1已交服务费）
	@ExcelField(title="电话报名服务费", align=2, sort=26)
	private String phoneApplyFee;		// 电话报名手续费
	@ExcelField(title="牵犬师会员号", align=2, sort=67)
	private String handlerMemberCode;		// 牵犬师会员号
	@ExcelField(title="牵犬师姓名", align=2, sort=68)
	private String handlerMemberNameTemp;		// 牵犬师会员号
	
	private String paymentMemberCode;		// 付款会员号
	private String stickerFlag;//申请贴纸标识:0不申请;1申请
	private String reviewState;		// 审核状态
	private Date reviewTime;		// 审核时间
	private String reviewRemarks;		// 审核原因
	@ExcelField(title="流水号", align=2, sort=34)
	private String runningNumber;		// 流水号
	@ExcelField(title="缴费", align=2, sort=35)
	private String paymentState;		// 支付状态
	private Date paymentTime;		// 支付时间
	private Date proccessTime;		// 处理时间
	private String proccessState;		// 处理状态
	private String expireFlag;	// 过期标记（0：正常；1：过期）
	protected String delFlag;  	// 删除标记（0：正常；1：删除；2：审核）
	@ExcelField(title="犬主名（牵犬人名）", align=2, sort=3)
	protected String dogOwnerAndHandler; 	// 如牵犬师和犬主会员号相同的，只显示犬主名
	@ExcelField(title="联系方式", align=2, sort=27)
	protected String contact; 	// 显示为犬主电话 + 牵犬人电话,如牵犬人和犬主会员号相同的，只显示犬主电话
	protected String accountBalance; 	// OA赛事报名列表页显示会员余额
	@ExcelField(title="提交日期", align=2, sort=28)
	protected Date createDateExcelField;	// 创建日期.Excel导出专用
	@ExcelField(title="毛色", align=2, sort=29)
	protected String colorFlag;	// Excel导出专用
	@ExcelField(title="年龄组别判断", align=2, sort=30)
	protected String isSameAgeGroup;	// Excel导出专用

	private String ageGroupJson;//后台管理系统报名所需
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date beginCreateDate;
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date endCreateDate;

	//秩序册导出用字段
	private String id;	// 导出专用id
	@ExcelField(title="备注", align=2, sort=6)
	private String remarks;	// 导出专用备注
	@ExcelField(title="秩序号", align=2, sort=2)
	private String orderNum;
	@ExcelField(title="三代是否满足", align=2, sort=13)
	private String dogGenerationFlag;		// 三代是否满足
	@ExcelField(title="秩序册上场顺序码", align=2, sort=15) 
	private String ageGroupFci;		// 秩序册上场顺序码
	@ExcelField(title="全部年龄组别", align=2, sort=15)
	private String ageGroupCn;		// 全部年龄组别
	@ExcelField(title="参展人", align=2, sort=23)
	private String handlerMemberName;		// 参赛人
	private String isPassReason = "";//不合格原因标志位
	private String reasonColor = "";//不合格颜色标志位
	@ExcelField(title="年龄组别-01", align=2, sort=41)
	protected String ageGroup01;	// Excel导出专用
	@ExcelField(title="年龄组别-02", align=2, sort=42)
	protected String ageGroup02;	// Excel导出专用
	@ExcelField(title="年龄组别-03", align=2, sort=43)
	protected String ageGroup03;	// Excel导出专用
	@ExcelField(title="年龄组别-04", align=2, sort=44)
	protected String ageGroup04;	// Excel导出专用
	@ExcelField(title="年龄组别-05", align=2, sort=45)
	protected String ageGroup05;	// Excel导出专用
	@ExcelField(title="年龄组别-06", align=2, sort=46)
	protected String ageGroup06;	// Excel导出专用
	@ExcelField(title="年龄组别-07", align=2, sort=47)
	protected String ageGroup07;	// Excel导出专用
	@ExcelField(title="年龄组别-08", align=2, sort=48)
	protected String ageGroup08;	// Excel导出专用
	@ExcelField(title="年龄组别-09", align=2, sort=49)
	protected String ageGroup09;	// Excel导出专用
	@ExcelField(title="年龄组别-10", align=2, sort=50)
	protected String ageGroup10;	// Excel导出专用
	@ExcelField(title="年龄组别-11", align=2, sort=51)
	protected String ageGroup11;	// Excel导出专用
	@ExcelField(title="年龄组别-12", align=2, sort=52)
	protected String ageGroup12;	// Excel导出专用
	@ExcelField(title="年龄组别-13", align=2, sort=53)
	protected String ageGroup13;	// Excel导出专用
	@ExcelField(title="年龄组别-14", align=2, sort=54)
	protected String ageGroup14;	// Excel导出专用
	@ExcelField(title="年龄组别-15", align=2, sort=55)
	protected String ageGroup15;	// Excel导出专用
	@ExcelField(title="年龄组别-16", align=2, sort=56)
	protected String ageGroup16;	// Excel导出专用
	@ExcelField(title="年龄组别-17", align=2, sort=57)
	protected String ageGroup17;	// Excel导出专用
	@ExcelField(title="年龄组别-18", align=2, sort=58)
	protected String ageGroup18;	// Excel导出专用
	@ExcelField(title="年龄组别-19", align=2, sort=59)
	protected String ageGroup19;	// Excel导出专用
	@ExcelField(title="年龄组别-20", align=2, sort=60)
	protected String ageGroup20;	// Excel导出专用



	@ExcelField(title="第2犬主姓名", align=2, sort=61)
	private String secondDogOwner;
	@ExcelField(title="第2犬主会员号", align=2, sort=62)
	private String secondOwnerMember;
	private String nowCouponNum;//优惠卷数量

	private String phoneApplyRunningNumber;
	@ExcelField(title="获得CC/RCC卡数量", align=2, sort=63)
	private Integer CCNum;//cc和rcc数量
	@ExcelField(title="获得JCC卡数量", align=2, sort=64)
	private Integer JCCnum;//jcc数量
	@ExcelField(title="是否完成青年登录", align=2, sort=65)
	private String isChampionLogin;//是否完成青年冠军登录
	
	@ExcelField(title="犬只月龄", align=2, sort=15) //新增导出月龄
	private int monthAge;	

	public int getMonthAge() {
		return monthAge;
	}

	public void setMonthAge(int monthAge) {
		this.monthAge = monthAge;
	}

	public Integer getCCNum() {
		return CCNum;
	}

	public void setCCNum(Integer CCNum) {
		this.CCNum = CCNum;
	}

	public Integer getJCCnum() {
		return JCCnum;
	}

	public void setJCCnum(Integer JCCnum) {
		this.JCCnum = JCCnum;
	}

	public String getIsChampionLogin() {
		return isChampionLogin;
	}

	public void setIsChampionLogin(String isChampionLogin) {
		this.isChampionLogin = isChampionLogin;
	}

	public String getSecondDogOwner() {
		return secondDogOwner;
	}

	public void setSecondDogOwner(String secondDogOwner) {
		this.secondDogOwner = secondDogOwner;
	}

	public String getSecondOwnerMember() {
		return secondOwnerMember;
	}

	public void setSecondOwnerMember(String secondOwnerMember) {
		this.secondOwnerMember = secondOwnerMember;
	}

	public String getIsOwner() {
		return isOwner;
	}

	public void setIsOwner(String isOwner) {
		this.isOwner = isOwner;
	}

	public ShowApply() {
		super();
	}

	public ShowApply(String id){
		super(id);
	}

	@Length(min=0, max=64, message="报名序号长度必须介于 0 和 64 之间")
	public String getApplyCode() {
		return applyCode;
	}

	public void setApplyCode(String applyCode) {
		this.applyCode = applyCode;
	}

	public Integer getShowNum() {
		return showNum;
	}

	public void setShowNum(Integer showNum) {
		this.showNum = showNum;
	}

	public String getMainShowId() {
		return mainShowId;
	}

	public void setMainShowId(String mainShowId) {
		this.mainShowId = mainShowId;
	}

	@Length(min=0, max=400, message="赛事编号长度必须介于 0 和 400 之间")
	public String getShowCode() {
		return showCode;
	}

	public void setShowCode(String showCode) {
		if(showCode!=null && showCode.length()>0){
			this.showNum = new Integer(showCode.split(",").length);
		}
		this.showCode = showCode;
	}

	public String getOrganizer() {
		return organizer;
	}

	public void setOrganizer(String organizer) {
		this.organizer = organizer;
	}

	@Length(min=0, max=64, message="犬主人姓名长度必须介于 0 和 64 之间")
	public String getDogOwnerNameCn() {
		return dogOwnerNameCn;
	}

	public void setDogOwnerNameCn(String dogOwnerNameCn) {
		this.dogOwnerNameCn = dogOwnerNameCn;
	}

	@Length(min=0, max=64, message="犬主英文名长度必须介于 0 和 64 之间")
	public String getDogOwnerNameEn() {
		return dogOwnerNameEn;
	}

	public void setDogOwnerNameEn(String dogOwnerNameEn) {
		this.dogOwnerNameEn = dogOwnerNameEn;
	}

	@Length(min=0, max=64, message="犬主人会员号长度必须介于 0 和 64 之间")
	public String getDogOwnerMemberCode() {
		return dogOwnerMemberCode;
	}

	public void setDogOwnerMemberCode(String dogOwnerMemberCode) {
		this.dogOwnerMemberCode = dogOwnerMemberCode;
	}

	@Length(min=0, max=64, message="犬种中文名长度必须介于 0 和 64 之间")
	public String getDogBreedNameCn() {
		return dogBreedNameCn;
	}

	public void setDogBreedNameCn(String dogBreedNameCn) {
		this.dogBreedNameCn = dogBreedNameCn;
	}

	@Length(min=0, max=64, message="犬种英文名长度必须介于 0 和 64 之间")
	public String getDogBreedNameEn() {
		return dogBreedNameEn;
	}

	public void setDogBreedNameEn(String dogBreedNameEn) {
		this.dogBreedNameEn = dogBreedNameEn;
	}

	@Length(min=0, max=20, message="犬种组长度必须介于 0 和 20 之间")
	public String getDogBreedGroup() {
		return dogBreedGroup;
	}

	public void setDogBreedGroup(String dogBreedGroup) {
		this.dogBreedGroup = dogBreedGroup;
	}

	@Length(min=0, max=100, message="犬名长度必须介于 0 和 100 之间")
	public String getDogName() {
		return dogName;
	}

	public void setDogName(String dogName) {
		this.dogName = dogName;
	}

	@Length(min=0, max=1, message="犬性别长度必须介于 0 和 1 之间")
	public String getDogGender() {
		return dogGender;
	}

	public void setDogGender(String dogGender) {
		this.dogGender = dogGender;
	}

	public String getDogGeneration() {
		return dogGeneration;
	}

	public void setDogGeneration(String dogGeneration) {
		this.dogGeneration = dogGeneration;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getDogBirthday() {
		return dogBirthday;
	}

	public void setDogBirthday(Date dogBirthday) {
		this.dogBirthday = dogBirthday;
	}

	@Length(min=0, max=64, message="血统证书号长度必须介于 0 和 64 之间")
	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}

	@Length(min=0, max=64, message="国外血统证书号长度必须介于 0 和 64 之间")
	public String getOtherCertified() {
		return otherCertified;
	}

	public void setOtherCertified(String otherCertified) {
		this.otherCertified = otherCertified;
	}

	@Length(min=0, max=64, message="FCI码长度必须介于 0 和 64 之间")
	public String getFciCode() {
		return fciCode;
	}

	public void setFciCode(String fciCode) {
		this.fciCode = fciCode;
	}

	@Length(min=0, max=64, message="芯片号长度必须介于 0 和 64 之间")
	public String getChipCode() {
		return chipCode;
	}

	public void setChipCode(String chipCode) {
		this.chipCode = chipCode;
	}

	@Length(min=0, max=64, message="父血统证书号长度必须介于 0 和 64 之间")
	public String getFdogPedigreeCertified() {
		return fdogPedigreeCertified;
	}

	public void setFdogPedigreeCertified(String fdogPedigreeCertified) {
		this.fdogPedigreeCertified = fdogPedigreeCertified;
	}

	@Length(min=0, max=100, message="父犬名长度必须介于 0 和 100 之间")
	public String getFdogName() {
		return fdogName;
	}

	public void setFdogName(String fdogName) {
		this.fdogName = fdogName;
	}

	@Length(min=0, max=64, message="母血统证书号长度必须介于 0 和 64 之间")
	public String getMdogPedigreeCertified() {
		return mdogPedigreeCertified;
	}

	public void setMdogPedigreeCertified(String mdogPedigreeCertified) {
		this.mdogPedigreeCertified = mdogPedigreeCertified;
	}

	@Length(min=0, max=100, message="母犬名长度必须介于 0 和 100 之间")
	public String getMdogName() {
		return mdogName;
	}

	public void setMdogName(String mdogName) {
		this.mdogName = mdogName;
	}

	@Length(min=0, max=64, message="繁殖人长度必须介于 0 和 64 之间")
	public String getBreeder() {
		return breeder;
	}

	public void setBreeder(String breeder) {
		this.breeder = breeder;
	}

	@Length(min=0, max=60, message="年龄组别长度必须介于 0 和 60 之间")
	public String getAgeGroup() {
		return ageGroup;
	}

	public void setAgeGroup(String ageGroup) {
		this.ageGroup = ageGroup;
	}

	@Length(min=0, max=1, message="赛事报名鉴定长度必须介于 0 和 1 之间")
	public String getShowApplyAppraisal() {
		return showApplyAppraisal;
	}

	public void setShowApplyAppraisal(String showApplyAppraisal) {
		this.showApplyAppraisal = showApplyAppraisal;
	}

	@Length(min=0, max=64, message="报名费长度必须介于 0 和 64 之间")
	public String getFee() {
		return fee;
	}

	public void setFee(String fee) {
		this.fee = fee;
	}

	public String getPaymentAmount() {
		return paymentAmount;
	}

	public void setPaymentAmount(String paymentAmount) {
		this.paymentAmount = paymentAmount;
	}

	public String getPaymentChargingItemId() {
		return paymentChargingItemId;
	}

	public void setPaymentChargingItemId(String paymentChargingItemId) {
		this.paymentChargingItemId = paymentChargingItemId;
	}

	public String getShortName() {
		return shortName;
	}

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	public String getOrderPrice() {
		return orderPrice;
	}

	public void setOrderPrice(String orderPrice) {
		this.orderPrice = orderPrice;
	}

	@Length(min=0, max=1, message="赛前退费长度必须介于 0 和 1 之间")
	public String getRefundFlag() {
		return refundFlag;
	}

	public void setRefundFlag(String refundFlag) {
		this.refundFlag = refundFlag;
	}

	@Length(min=0, max=1, message="赛场请假长度必须介于 0 和 1 之间")
	public String getAbsenceFlag() {
		return absenceFlag;
	}

	public void setAbsenceFlag(String absenceFlag) {
		this.absenceFlag = absenceFlag;
	}

	@Length(min=0, max=1, message="BBE长度必须介于 0 和 1 之间")
	public String getBbeFlag() {
		return bbeFlag;
	}

	public void setBbeFlag(String bbeFlag) {
		this.bbeFlag = bbeFlag;
	}

	public String getPhoneApplyFlag() {
		return phoneApplyFlag;
	}

	public void setPhoneApplyFlag(String phoneApplyFlag) {
		this.phoneApplyFlag = phoneApplyFlag;
	}

	public String getPhoneApplyFee() {
		return phoneApplyFee;
	}

	public void setPhoneApplyFee(String phoneApplyFee) {
		this.phoneApplyFee = phoneApplyFee;
	}

	@Length(min=0, max=64, message="牵犬师会员号长度必须介于 0 和 64之间")
	public String getHandlerMemberCode() {
		return handlerMemberCode;
	}

	public void setHandlerMemberCode(String handlerMemberCode) {
		this.handlerMemberCode = handlerMemberCode;
	}

	@Length(min=0, max=64, message="付款会员号长度必须介于 0 和 64 之间")
	public String getPaymentMemberCode() {
		return paymentMemberCode;
	}

	public void setPaymentMemberCode(String paymentMemberCode) {
		this.paymentMemberCode = paymentMemberCode;
	}

	public String getStickerFlag() {
		return stickerFlag;
	}

	public void setStickerFlag(String stickerFlag) {
		this.stickerFlag = stickerFlag;
	}

	@Length(min=0, max=64, message="审核状态长度必须介于 0 和 64 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}

	@Length(min=0, max=64, message="审核原因长度必须介于 0 和 64 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	@Length(min=0, max=64, message="流水号长度必须介于 0 和 64 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min=0, max=64, message="支付状态长度必须介于 0 和 64 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProccessTime() {
		return proccessTime;
	}

	public void setProccessTime(Date proccessTime) {
		this.proccessTime = proccessTime;
	}

	@Length(min=0, max=64, message="处理状态长度必须介于 0 和 64 之间")
	public String getProccessState() {
		return proccessState;
	}

	public void setProccessState(String proccessState) {
		this.proccessState = proccessState;
	}

	public String getExpireFlag() {
		return expireFlag;
	}

	public void setExpireFlag(String expireFlag) {
		this.expireFlag = expireFlag;
	}

	public String getId() {
		return super.id;
	}

	public void setId(String id) {
		super.id = id;
	}

	public String getRemarks() {
		return super.remarks;
	}

	public void setRemarks(String remarks) {
		super.remarks = remarks;
	}


	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public String getDogOwnerAndHandler() {
		return dogOwnerAndHandler;
	}

	public void setDogOwnerAndHandler(String dogOwnerAndHandler) {
		this.dogOwnerAndHandler = dogOwnerAndHandler;
	}

	public String getContact() {
		return contact;
	}

	public void setContact(String contact) {
		this.contact = contact;
	}

	public String getAccountBalance() {
		return accountBalance;
	}

	public void setAccountBalance(String accountBalance) {
		this.accountBalance = accountBalance;
	}

	public Date getCreateDateExcelField() {
		return super.createDate;
	}

	public void setCreateDateExcelField(Date createDateExcelField) {
		this.createDateExcelField = createDateExcelField;
	}

	public String getAgeGroupJson() {
		return ageGroupJson;
	}

	public void setAgeGroupJson(String ageGroupJson) {
		this.ageGroupJson = ageGroupJson;
	}

	public String getColorFlag() {
		return colorFlag;
	}

	public void setColorFlag(String colorFlag) {
		this.colorFlag = colorFlag;
	}

	public String getIsSameAgeGroup() {
		return isSameAgeGroup;
	}

	public void setIsSameAgeGroup(String isSameAgeGroup) {
		this.isSameAgeGroup = isSameAgeGroup;
	}

	public String getAgeGroup01() {
		return ageGroup01;
	}

	public void setAgeGroup01(String ageGroup01) {
		this.ageGroup01 = ageGroup01;
	}

	public String getAgeGroup02() {
		return ageGroup02;
	}

	public void setAgeGroup02(String ageGroup02) {
		this.ageGroup02 = ageGroup02;
	}

	public String getAgeGroup03() {
		return ageGroup03;
	}

	public void setAgeGroup03(String ageGroup03) {
		this.ageGroup03 = ageGroup03;
	}

	public String getAgeGroup04() {
		return ageGroup04;
	}

	public void setAgeGroup04(String ageGroup04) {
		this.ageGroup04 = ageGroup04;
	}

	public String getAgeGroup05() {
		return ageGroup05;
	}

	public void setAgeGroup05(String ageGroup05) {
		this.ageGroup05 = ageGroup05;
	}

	public String getAgeGroup06() {
		return ageGroup06;
	}

	public void setAgeGroup06(String ageGroup06) {
		this.ageGroup06 = ageGroup06;
	}

	public String getAgeGroup07() {
		return ageGroup07;
	}

	public void setAgeGroup07(String ageGroup07) {
		this.ageGroup07 = ageGroup07;
	}

	public String getAgeGroup08() {
		return ageGroup08;
	}

	public void setAgeGroup08(String ageGroup08) {
		this.ageGroup08 = ageGroup08;
	}

	public String getAgeGroup09() {
		return ageGroup09;
	}

	public void setAgeGroup09(String ageGroup09) {
		this.ageGroup09 = ageGroup09;
	}

	public String getAgeGroup10() {
		return ageGroup10;
	}

	public void setAgeGroup10(String ageGroup10) {
		this.ageGroup10 = ageGroup10;
	}

	public String getAgeGroup11() {
		return ageGroup11;
	}

	public void setAgeGroup11(String ageGroup11) {
		this.ageGroup11 = ageGroup11;
	}

	public String getAgeGroup12() {
		return ageGroup12;
	}

	public void setAgeGroup12(String ageGroup12) {
		this.ageGroup12 = ageGroup12;
	}

	public String getAgeGroup13() {
		return ageGroup13;
	}

	public void setAgeGroup13(String ageGroup13) {
		this.ageGroup13 = ageGroup13;
	}

	public String getAgeGroup14() {
		return ageGroup14;
	}

	public void setAgeGroup14(String ageGroup14) {
		this.ageGroup14 = ageGroup14;
	}

	public String getAgeGroup15() {
		return ageGroup15;
	}

	public void setAgeGroup15(String ageGroup15) {
		this.ageGroup15 = ageGroup15;
	}

	public String getAgeGroup16() {
		return ageGroup16;
	}

	public void setAgeGroup16(String ageGroup16) {
		this.ageGroup16 = ageGroup16;
	}

	public String getAgeGroup17() {
		return ageGroup17;
	}

	public void setAgeGroup17(String ageGroup17) {
		this.ageGroup17 = ageGroup17;
	}

	public String getAgeGroup18() {
		return ageGroup18;
	}

	public void setAgeGroup18(String ageGroup18) {
		this.ageGroup18 = ageGroup18;
	}

	public String getAgeGroup19() {
		return ageGroup19;
	}

	public void setAgeGroup19(String ageGroup19) {
		this.ageGroup19 = ageGroup19;
	}

	public String getAgeGroup20() {
		return ageGroup20;
	}

	public void setAgeGroup20(String ageGroup20) {
		this.ageGroup20 = ageGroup20;
	}

	public String getAgeGroupCn() {
		return ageGroupCn;
	}

	public void setAgeGroupCn(String ageGroupCn) {
		this.ageGroupCn = ageGroupCn;
	}

	public String getIsPassReason() {
		return isPassReason;
	}

	public void setIsPassReason(String isPassReason) {
		this.isPassReason = isPassReason;
	}

	public String getReasonColor() {
		return reasonColor;
	}

	public void setReasonColor(String reasonColor) {
		this.reasonColor = reasonColor;
	}

	public String getOrderNum() {
		return orderNum;
	}

	public void setOrderNum(String orderNum) {
		this.orderNum = orderNum;
	}

	public String getDogGenerationFlag() {
		return dogGenerationFlag;
	}

	public void setDogGenerationFlag(String dogGenerationFlag) {
		this.dogGenerationFlag = dogGenerationFlag;
	}

	public String getAgeGroupFci() {
		return ageGroupFci;
	}

	public void setAgeGroupFci(String ageGroupFci) {
		this.ageGroupFci = ageGroupFci;
	}

	public String getHandlerMemberName() {
		return handlerMemberName;
	}

	public void setHandlerMemberName(String handlerMemberName) {
		this.handlerMemberName = handlerMemberName;
	}

	public String getNowCouponNum() {
		return nowCouponNum;
	}

	public void setNowCouponNum(String nowCouponNum) {
		this.nowCouponNum = nowCouponNum;
	}

	public String getPhoneApplyRunningNumber() {
		return phoneApplyRunningNumber;
	}

	public void setPhoneApplyRunningNumber(String phoneApplyRunningNumber) {
		this.phoneApplyRunningNumber = phoneApplyRunningNumber;
	}

	public String getHandlerMemberNameTemp() {
		return handlerMemberNameTemp;
	}

	public void setHandlerMemberNameTemp(String handlerMemberNameTemp) {
		this.handlerMemberNameTemp = handlerMemberNameTemp;
	}
	
	


}