/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 赛事顾问Entity
 * @author yuanshuai
 * @version 2025-07-02
 */
public class ShowAdvisor extends DataEntity<ShowAdvisor> {
	
	private static final long serialVersionUID = 1L;
	private String name;		// 姓名
	private String nameEn;		// 姓名-英文
	private String picture;		// 图片
	private String involvedInto;		// 从业时间
	private String involvedIntoEn;		// 从业时间-英文
	private String electedInto;		// 担任轮值顾问年
	private String electedIntoEn;		// 担任轮值顾问年-英文
	private String title;		// 头衔
	private String titleEn;		// 头衔-英文
	private String experience;		// 从业经历
	private String experienceEn;		// 从业经历-英文
	private String kennelName;		// 犬舍名称
	private String kennelNameEn;		// 犬舍名称-英文
	private String breedType;		// 繁殖品种
	private String breedTypeEn;		// 繁殖品种-英文
	
	public ShowAdvisor() {
		super();
	}

	public ShowAdvisor(String id){
		super(id);
	}

	@Length(min=1, max=100, message="姓名长度必须介于 1 和 100 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Length(min=0, max=50, message="姓名-英文长度必须介于 0 和 50 之间")
	public String getNameEn() {
		return nameEn;
	}

	public void setNameEn(String nameEn) {
		this.nameEn = nameEn;
	}
	
	@Length(min=0, max=100, message="图片长度必须介于 0 和 100 之间")
	public String getPicture() {
		return picture;
	}

	public void setPicture(String picture) {
		this.picture = picture;
	}
	
	@Length(min=0, max=20, message="从业时间长度必须介于 0 和 20 之间")
	public String getInvolvedInto() {
		return involvedInto;
	}

	public void setInvolvedInto(String involvedInto) {
		this.involvedInto = involvedInto;
	}
	
	@Length(min=0, max=20, message="从业时间-英文长度必须介于 0 和 20 之间")
	public String getInvolvedIntoEn() {
		return involvedIntoEn;
	}

	public void setInvolvedIntoEn(String involvedIntoEn) {
		this.involvedIntoEn = involvedIntoEn;
	}
	
	@Length(min=0, max=150, message="担任轮值顾问年长度必须介于 0 和 150 之间")
	public String getElectedInto() {
		return electedInto;
	}

	public void setElectedInto(String electedInto) {
		this.electedInto = electedInto;
	}
	
	@Length(min=0, max=150, message="担任轮值顾问年-英文长度必须介于 0 和 150 之间")
	public String getElectedIntoEn() {
		return electedIntoEn;
	}

	public void setElectedIntoEn(String electedIntoEn) {
		this.electedIntoEn = electedIntoEn;
	}
	
	@Length(min=0, max=100, message="头衔长度必须介于 0 和 100 之间")
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}
	
	@Length(min=0, max=100, message="头衔-英文长度必须介于 0 和 100 之间")
	public String getTitleEn() {
		return titleEn;
	}

	public void setTitleEn(String titleEn) {
		this.titleEn = titleEn;
	}
	
	public String getExperience() {
		return experience;
	}

	public void setExperience(String experience) {
		this.experience = experience;
	}
	
	public String getExperienceEn() {
		return experienceEn;
	}

	public void setExperienceEn(String experienceEn) {
		this.experienceEn = experienceEn;
	}
	
	@Length(min=0, max=100, message="犬舍名称长度必须介于 0 和 100 之间")
	public String getKennelName() {
		return kennelName;
	}

	public void setKennelName(String kennelName) {
		this.kennelName = kennelName;
	}
	
	@Length(min=0, max=100, message="犬舍名称-英文长度必须介于 0 和 100 之间")
	public String getKennelNameEn() {
		return kennelNameEn;
	}

	public void setKennelNameEn(String kennelNameEn) {
		this.kennelNameEn = kennelNameEn;
	}
	
	@Length(min=0, max=100, message="繁殖品种长度必须介于 0 和 100 之间")
	public String getBreedType() {
		return breedType;
	}

	public void setBreedType(String breedType) {
		this.breedType = breedType;
	}
	
	@Length(min=0, max=100, message="繁殖品种-英文长度必须介于 0 和 100 之间")
	public String getBreedTypeEn() {
		return breedTypeEn;
	}

	public void setBreedTypeEn(String breedTypeEn) {
		this.breedTypeEn = breedTypeEn;
	}
	
}