/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;
import java.util.List;

/**
 * 赛事主表Entity
 * @author lgl
 * @version 2016-07-13
 */
/**
 * @author user
 *
 */
/**
 * @author user
 *
 */
public class MainShows extends DataEntity<MainShows> {

	private static final long serialVersionUID = 1L;
	private String showLocation;		// 赛事地点
	private String mainShowName;		// 主赛事名称
	private Date closingTime;		// 报名关闭时间
	private String organizer;		// 主办单位
	private String undertaker;		// 承办单位
	private String referee;		// 裁判
	private String register;		// 报名
	private String orgnizeType;		// 举办方式（自办合办）
	private String dogNumMax;		// 犬只数上限
	private String branchShowDetail;		// 场次明细
	private String showCancel;		// 赛事取消
	private String venuesId;		// 场馆id(app)
	private String attention;		// 特别注意事项
	private Date startTime;		// 赛事开始时间（子赛事中最早的开始时间）
	private Date endTime;		// 赛事结束时间（子赛事中最晚的结束时间）
	private String isTop;		// 是否顶置，1为顶置

	private String scheduleImage; //比赛赛程表
	private String hospitalId; //酒店id
	private String showVenueId; //场馆id(官网)
	private String thumbnailImage; //缩略图
	private String handerImage; //长图
	private String officeId; //办公室
	private List<ChildShows> childShowsList = Lists.newArrayList();		// 子表列表
	// 赛事收费模式，0旧模式1新模式
	private String businessModelFlag;
	private String orgnizeTypeAndModelFlag;
	private String year;//设置赛事年份
	private String isShowType;//是否为show特殊类型 0国秀裁判照 1默认裁判照 2特殊裁判照
	
	private List<ShowMainJudgeInfo> judgeInfoList = Lists.newArrayList();		// 赛事裁判照片列表
	
	private String isShowWebsite;//官网是否展示 0展示 1不展示
	
	private Date isTopTime;	// 置顶日期
	
	//cku_image
	private String imageMinUrl;

	private String imageMaxUrl;
	
	private String imageMinUrlId;

	private String imageMaxUrlId;
	
	public String getImageMinUrlId() {
		return imageMinUrlId;
	}

	public void setImageMinUrlId(String imageMinUrlId) {
		this.imageMinUrlId = imageMinUrlId;
	}

	public String getImageMaxUrlId() {
		return imageMaxUrlId;
	}

	public void setImageMaxUrlId(String imageMaxUrlId) {
		this.imageMaxUrlId = imageMaxUrlId;
	}

	public String getImageMinUrl() {
		return imageMinUrl;
	}

	public void setImageMinUrl(String imageMinUrl) {
		this.imageMinUrl = imageMinUrl;
	}

	public String getImageMaxUrl() {
		return imageMaxUrl;
	}

	public void setImageMaxUrl(String imageMaxUrl) {
		this.imageMaxUrl = imageMaxUrl;
	}

	public Date getIsTopTime() {
		return isTopTime;
	}

	public void setIsTopTime(Date isTopTime) {
		this.isTopTime = isTopTime;
	}

	public String getIsShowWebsite() {
		return isShowWebsite;
	}

	public void setIsShowWebsite(String isShowWebsite) {
		this.isShowWebsite = isShowWebsite;
	}

	public List<ShowMainJudgeInfo> getJudgeInfoList() {
		return judgeInfoList;
	}

	public void setJudgeInfoList(List<ShowMainJudgeInfo> judgeInfoList) {
		this.judgeInfoList = judgeInfoList;
	}

	public String getIsShowType() {
		return isShowType;
	}

	public void setIsShowType(String isShowType) {
		this.isShowType = isShowType;
	}

	public MainShows() {
		super();
	}

	public MainShows(String id){
		super(id);
	}

	@Length(min=0, max=100, message="赛事地点长度必须介于 0 和 100 之间")
	public String getShowLocation() {
		return showLocation;
	}

	public void setShowLocation(String showLocation) {
		this.showLocation = showLocation;
	}

	@Length(min=0, max=100, message="主赛事名称长度必须介于 0 和 100 之间")
	public String getMainShowName() {
		return mainShowName;
	}

	public void setMainShowName(String mainShowName) {
		this.mainShowName = mainShowName;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getClosingTime() {
		return closingTime;
	}

	public void setClosingTime(Date closingTime) {
		this.closingTime = closingTime;
	}

	@Length(min=0, max=50, message="主办单位长度必须介于 0 和 50 之间")
	public String getOrganizer() {
		return organizer;
	}

	public void setOrganizer(String organizer) {
		this.organizer = organizer;
	}

	public String getUndertaker() {
		return undertaker;
	}

	public void setUndertaker(String undertaker) {
		this.undertaker = undertaker;
	}

	@Length(min=0, max=100, message="裁判长度必须介于 0 和 100 之间")
	public String getReferee() {
		return referee;
	}

	public void setReferee(String referee) {
		this.referee = referee;
	}

	@Length(min=0, max=100, message="报名长度必须介于 0 和 100 之间")
	public String getRegister() {
		return register;
	}

	public void setRegister(String register) {
		this.register = register;
	}

	@Length(min=0, max=100, message="举办方式（自办合办）长度必须介于 0 和 100 之间")
	public String getOrgnizeType() {
		return orgnizeType;
	}

	public void setOrgnizeType(String orgnizeType) {
		this.orgnizeType = orgnizeType;
	}

	@Length(min=0, max=11, message="犬只数上限长度必须介于 0 和 11 之间")
	public String getDogNumMax() {
		return dogNumMax;
	}

	public void setDogNumMax(String dogNumMax) {
		this.dogNumMax = dogNumMax;
	}

	@Length(min=0, max=100, message="场次明细长度必须介于 0 和 100 之间")
	public String getBranchShowDetail() {
		return branchShowDetail;
	}

	public void setBranchShowDetail(String branchShowDetail) {
		this.branchShowDetail = branchShowDetail;
	}

	@Length(min=0, max=11, message="赛事取消长度必须介于 0 和 11 之间")
	public String getShowCancel() {
		return showCancel;
	}

	public void setShowCancel(String showCancel) {
		this.showCancel = showCancel;
	}

	@Length(min=0, max=100, message="场馆id长度必须介于 0 和 100 之间")
	public String getVenuesId() {
		return venuesId;
	}

	public void setVenuesId(String venuesId) {
		this.venuesId = venuesId;
	}

	@Length(min=0, max=255, message="特别注意事项长度必须介于 0 和 255 之间")
	public String getAttention() {
		return attention;
	}

	public void setAttention(String attention) {
		this.attention = attention;
	}

	public List<ChildShows> getChildShowsList() {
		return childShowsList;
	}

	public void setChildShowsList(List<ChildShows> childShowsList) {
		this.childShowsList = childShowsList;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public String getIsTop() {
		return isTop;
	}

	public void setIsTop(String isTop) {
		this.isTop = isTop;
	}

	public String getScheduleImage() {
		return scheduleImage;
	}

	public void setScheduleImage(String scheduleImage) {
		this.scheduleImage = scheduleImage;
	}

	public String getHospitalId() {
		return hospitalId;
	}

	public void setHospitalId(String hospitalId) {
		this.hospitalId = hospitalId;
	}

	public String getThumbnailImage() {
		return thumbnailImage;
	}

	public void setThumbnailImage(String thumbnailImage) {
		this.thumbnailImage = thumbnailImage;
	}

	public String getHanderImage() {
		return handerImage;
	}

	public void setHanderImage(String handerImage) {
		this.handerImage = handerImage;
	}

	public String getOfficeId() {
		return officeId;
	}

	public void setOfficeId(String officeId) {
		this.officeId = officeId;
	}

	public String getShowVenueId() {
		return showVenueId;
	}

	public void setShowVenueId(String showVenueId) {
		this.showVenueId = showVenueId;
	}


	private String handlerPhotoFlag;//赛事报名牵犬师图片校验标记位：0不校验；1校验'

	public String getHandlerPhotoFlag() {
		return handlerPhotoFlag;
	}

	public void setHandlerPhotoFlag(String handlerPhotoFlag) {
		this.handlerPhotoFlag = handlerPhotoFlag;
	}

	public String getBusinessModelFlag() {
		return businessModelFlag;
	}

	public void setBusinessModelFlag(String businessModelFlag) {
		this.businessModelFlag = businessModelFlag;
	}

	public String getOrgnizeTypeAndModelFlag() {
		return orgnizeTypeAndModelFlag;
	}

	public void setOrgnizeTypeAndModelFlag(String orgnizeTypeAndModelFlag) {
		this.orgnizeTypeAndModelFlag = orgnizeTypeAndModelFlag;
	}

	public String getYear() {
		return year;
	}

	public void setYear(String year) {
		this.year = year;
	}
}