/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.project.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 技术项目表Entity
 * 
 * @author Sunny
 * @version 2021-12-07
 */
public class CkuProject extends DataEntity<CkuProject> {

	private static final long serialVersionUID = 1L;
	private String name; // 项目名称
	private String deptName; // 项目所在部门名称
	private String adminName; // 项目负责人姓名
	private String introduction; // 项目简介
	private Date startTime; // 项目开始时间
	private Date endTime; // 项目结束时间
	private Integer startWeek; //开始时间所处周
	private Integer endWeek; //结束时间所处周
	private Integer queryYear; //结束时间所处周

	public CkuProject() {
		super();
	}

	public CkuProject(String id) {
		super(id);
	}

	@Length(min = 0, max = 128, message = "项目名称长度必须介于 0 和 128 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Length(min = 0, max = 512, message = "项目简介长度必须介于 0 和 512 之间")
	public String getIntroduction() {
		return introduction;
	}

	public void setIntroduction(String introduction) {
		this.introduction = introduction;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}
	
	@Length(min = 0, max = 64, message = "项目所在部门名称长度必须介于 0 和 64 之间")
	public String getDeptName() {
		return deptName;
	}

	public void setDeptName(String deptName) {
		this.deptName = deptName;
	}

	@Length(min = 1, max = 64, message = "项目负责人名称长度必须介于 1 和 64 之间")
	public String getAdminName() {
		return adminName;
	}

	public void setAdminName(String adminName) {
		this.adminName = adminName;
	}

	public Integer getStartWeek() {
		return startWeek;
	}

	public void setStartWeek(Integer startWeek) {
		this.startWeek = startWeek;
	}

	public Integer getEndWeek() {
		return endWeek;
	}

	public void setEndWeek(Integer endWeek) {
		this.endWeek = endWeek;
	}

	public Integer getQueryYear() {
		return queryYear;
	}

	public void setQueryYear(Integer queryYear) {
		this.queryYear = queryYear;
	}
	
}