/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.service;

import java.io.IOException;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.handler.dao.HandlerDiplomaDao;
import com.cku.oa.handler.entity.HandlerDiploma;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.ExpressQueueService;
import com.cku.oa.sys.service.RemindService;
import com.cku.oa.sys.zalog.SysContext;
import com.cku.oa.trainschool.dao.TrainingInstitutionDao;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 结业证书Service
 * @author 柴雪腾
 * @version 2016-08-08
 */
@Service
@Transactional(readOnly = true)
public class HandlerDiplomaService extends CrudService<HandlerDiplomaDao, HandlerDiploma> {

	@Autowired
	private RemindService remindService;
	@Autowired
	private ExpressQueueService expressQueueService;
	@Autowired
	private TrainingInstitutionDao trainingInstitutionDao;
	@Autowired
	public MemberDao memberDao;
	
	
	
	public HandlerDiploma get(String id) {
		return super.get(id);
	}
	
	public List<HandlerDiploma> findList(HandlerDiploma handlerDiploma) {
		return super.findList(handlerDiploma);
	}
	
	public Page<HandlerDiploma> findPage(Page<HandlerDiploma> page, String handlerType,HandlerDiploma handlerDiploma) {
		return super.findPage(page, handlerDiploma);
	}
	

	
	@Transactional(readOnly = false)
	public void save(HandlerDiploma handlerDiploma) {
		if (handlerDiploma.getIsNewRecord()){//保存操作
			handlerDiploma.setPaymentState("1");
			handlerDiploma.setPaymentTime(null);
			handlerDiploma.setReviewer(null);
			handlerDiploma.setReviewState("0");
			handlerDiploma.setReviewTime(null);
			handlerDiploma.setProccessState("0");
			handlerDiploma.setProccessTime(null);
			handlerDiploma.setPrintState("0");
			String schoolId = handlerDiploma.getSchoolId();
			if(StringUtils.isNotBlank(schoolId)){
				TrainingInstitution ti = trainingInstitutionDao.get(schoolId);
				handlerDiploma.setSchoolNameCn(ti.getSchoolNameCn());
				handlerDiploma.setSchoolNameEn(ti.getSchoolNameEn());
			}
		}
		super.save(handlerDiploma);
	}
	
	@Transactional(readOnly = false)
	public void delete(HandlerDiploma handlerDiploma) {
		super.delete(handlerDiploma);
	}
	
	/**
	 * 审核
	 * @Author chaixueteng
	 * @2016年8月9日上午10:36:36
	 */
	@Transactional(readOnly = false)
	public void review(HandlerDiploma hd) throws ZAException  {
		try {
			String id = hd.getId();
			String memberCode = hd.getMemberCode();
			String reviewRemarks = hd.getReviewRemarks();
			HandlerDiploma handlerDiploma = super.get(id);
			SysContext sysContext = new SysContext(handlerDiploma.getPaymentState(),handlerDiploma.getReviewState(),handlerDiploma.getProccessState());
			handlerDiploma = new HandlerDiploma(id);
			if("1".equals(hd.getReviewState())){
				handlerDiploma.setReviewState("1");
				handlerDiploma.setReviewTime(new Date());
				sysContext.confirmSuccess(sysContext,"培训结业证书",handlerDiploma.getMemberCode(),"handler_diploma",handlerDiploma.getId(),handlerDiploma.getRunningNumber(),(str)->{

				});
				remindService.addRemind("您的结业证书已经审核通过，可以报名参加美容师考试喽",memberCode);
			}else if("2".equals(hd.getReviewState())){
				handlerDiploma.setReviewState("2");
				handlerDiploma.setReviewTime(new Date());
				handlerDiploma.setReviewRemarks(reviewRemarks);
				sysContext.confirmFail(sysContext,"培训结业证书",reviewRemarks,handlerDiploma.getMemberCode(),"handler_diploma",handlerDiploma.getId(),handlerDiploma.getRunningNumber(),(str)->{

				});
				remindService.addRemind("您提交的"+hd.getName()+"学员的结业证书资料有误，请重新提交。",memberCode);
			}
			dao.review(handlerDiploma);
		} catch (ZAException e) {
			throw e;
		}
		
	}
	
	/**
	 * 点击生成
	 * @Author chaixueteng
	 * @2016年8月9日上午10:44:08
	 */
	@Transactional(readOnly = false)
	public void createCode(String id) throws ZAException  {
		String DiplomaCode=null;
		String type=null;
		String schoolShortName=null;
		String[] ids = id.split(",");
		for (int i = 0; i < ids.length; i++) {
			HandlerDiploma handlerDiploma = super.get(ids[i]);
			if (StringUtils.isBlank(handlerDiploma.getCertificateCode())&&"2".equals(handlerDiploma.getPaymentState())&&"1".equals(handlerDiploma.getReviewState())) {
				String certificateLevel = handlerDiploma.getCertificateLevel();
				String handlerType = handlerDiploma.getHandlerType();
				String level = certificateLevel.replaceAll("[^A-Z^]","");
				if(StringUtils.isNotBlank(handlerDiploma.getSchoolId())){
					schoolShortName = handlerDiploma.getTrainingInstitution().getSchoolShortName();
				}
				if ("1".equals(handlerType)) {//训犬师
					String trainLevel = certificateLevel.substring(0, 6);
					if ("家庭犬训练师".equals(trainLevel)) {
						type="F";
					}else if("敏捷犬训练师".equals(trainLevel)){
						type="A";
					}else if("犬行为训练师".equals(trainLevel)){
						type="T";
					}
					DiplomaCode=SysCodeUtil.getTrainDiplomaCode(type, schoolShortName, level);
				}else{//牵犬师
					if ("精英培训班".equals(certificateLevel.trim())) {
						DiplomaCode = SysCodeUtil.getEliteDiplomaCode();
					}else{
						DiplomaCode=SysCodeUtil.getHandlerDiplomaCode(schoolShortName,level);
					}
				}			
				handlerDiploma = new HandlerDiploma(ids[i]);
				handlerDiploma.setCertificateCode(DiplomaCode);
				handlerDiploma.setIssueDate(new Date()); 
				dao.createCode(handlerDiploma); 
			}
		}
	}

	/**
	 * 批量通过
	 * @Author chaixueteng
	 * @2016年8月18日下午3:50:49
	 */
	@Transactional(readOnly = false)
	public void listSubmit(String id) throws ZAException  {
		String[] ids = id.split(",");
		HandlerDiploma hd = new HandlerDiploma();
		for (int i = 0; i < ids.length; i++) {
			HandlerDiploma diploma = dao.get(ids[i]);
			SysContext sysContext = new SysContext(diploma.getPaymentState(),diploma.getReviewState(),diploma.getProccessState());
			User user = UserUtils.getUser();
			if (StringUtils.isNotBlank(user.getName())){
				hd.setReviewer(user.getName());
			}
			hd.setId(ids[i]);
			hd.setReviewState("1");
			hd.setReviewTime(new Date());
			sysContext.confirmSuccess(sysContext,"培训结业证书",diploma.getMemberCode(),"handler_diploma",diploma.getId(),diploma.getRunningNumber(),(str)->{ });
			dao.review(hd);
		}
	}
	/**
	 * 训犬师批量通过
	 * @Author chaixueteng
	 * @2016年8月18日下午3:50:49
	 */
	@Transactional(readOnly = false)
	public void trainListSubmit() throws ZAException  {
		//得到未审核的结业列表
		List<HandlerDiploma> diplomaList=dao.getTrainDiplomaList();
		for (HandlerDiploma handlerDiploma : diplomaList) {
			SysContext sysContext = new SysContext(handlerDiploma.getPaymentState(),handlerDiploma.getReviewState(),handlerDiploma.getProccessState());
			User user = UserUtils.getUser();
			if (StringUtils.isNotBlank(user.getName())){
				handlerDiploma.setReviewer(user.getName());
			}
			handlerDiploma.setReviewState("1");
			handlerDiploma.setReviewTime(new Date());
			sysContext.confirmSuccess(sysContext,"培训结业证书",handlerDiploma.getMemberCode(),"handler_diploma",handlerDiploma.getId(),handlerDiploma.getRunningNumber(),(str)->{
			});
			dao.review(handlerDiploma);
		}
	}

	/**
	 *结业证书导出
	 * @Author chaixueteng
	 * @2016年8月18日下午3:50:26
	 */
	public void export(HandlerDiploma handlerDiploma,HttpServletResponse response)throws IOException {
		List<HandlerDiploma> hdList=dao.getHandlerList(handlerDiploma);
		for (HandlerDiploma hd : hdList) {
			hd.setSchoolNameCn(hd.getSchoolNameCn());
		}
		new ExportExcel("", HandlerDiploma.class, 1)
		.setDataList(hdList).write(response, "牵犬师结业证书表.xlsx").dispose();
	}
	/**
	 *训犬师结业证书导出
	 * @Author chaixueteng
	 * @2016年8月18日下午3:50:26
	 */
	public void trainExport(HandlerDiploma handlerDiploma,HttpServletResponse response)throws IOException {
		List<HandlerDiploma> hdList=dao.getTrainList(handlerDiploma);
		for (HandlerDiploma hd : hdList) {
			hd.setSchoolNameCn(hd.getSchoolNameCn());
		}
		new ExportExcel("", HandlerDiploma.class, 1)
		.setDataList(hdList).write(response, "训犬师结业证书表.xlsx").dispose();
	}
	
	/**
	 * 获取结业证书等级
	 * @Author chaixueteng
	 * @2016年8月20日下午1:55:14
	 */
	public String getLevel(String memberCode)throws ZAException {
		List<String> diplomaLevel = dao.getDiplomaLevel(memberCode);
		String level = null;
		String level2 = null;
		if(diplomaLevel.size()>0){
			level = diplomaLevel.get(0);
			level2 = diplomaLevel.get(diplomaLevel.size()-1);
			if("精英培训班".equals(level)){
				return level;
			}else{
				return level2.replaceAll("[^a-z^A-Z^0-9]", "");
			}
		} else {
			return level;
		}
		
	}
	
	/**
	 * 重置打印
	 * @Author chaixueteng
	 * @2016年8月23日下午3:26:23
	 */
	@Transactional(readOnly = false)
	public void resetPrint(String id) {
		HandlerDiploma handlerDiploma = super.get(id);
		handlerDiploma.setPrintState("0");
		dao.resetPrint(handlerDiploma);
	}


	/**
	 * 训犬师列表
	 * @Author chaixueteng
	 * @2016年8月26日下午4:43:42
	 */
	public Page<HandlerDiploma> findTrainPage(Page<HandlerDiploma> page,
			HandlerDiploma handlerDiploma) {
		handlerDiploma.setPage(page);
		page.setList(dao.findTrainList(handlerDiploma));
		return page;
	}

	public Page<HandlerDiploma> findTrainListByApp(Page<HandlerDiploma> page,
											  HandlerDiploma handlerDiploma) {
		handlerDiploma.setPage(page);
		page.setList(dao.findTrainListByApp(handlerDiploma));
		return page;
	}



	/**
	 * 查询未处理的结业证书 --牵犬师
	 * @Author chaixueteng
	 * @2016年8月31日下午2:31:34
	 */
	public int getHandlerDiplomaCount() {
		return dao.getHandlerDiplomaCount();
	}
	/**
	 * 查询未处理的结业证书--训犬师
	 * @Author chaixueteng
	 * @2016年8月31日下午2:31:34
	 */
	public int getTrainDiplomaCount() {
		return dao.getTrainDiplomaCount();
	}

	/**
	 * 打印
	 * @Author chaixueteng
	 * @2016年9月3日下午4:41:54
	 */
	@Transactional(readOnly = false)
	public HandlerDiploma print(HandlerDiploma handlerDiploma) {
		SysContext sysContext = new SysContext(null,null,null);
		sysContext.noStateExecute(sysContext,"牵犬师结业证书打印",handlerDiploma.getMemberCode(),"handler_diploma",handlerDiploma.getId(),handlerDiploma.getRunningNumber(),(str)->{});
		handlerDiploma.setPrintState("1");
		dao.resetPrint(handlerDiploma);
		//推送消息
		expressQueueService.push(handlerDiploma.getMemberCode(), handlerDiploma.getRunningNumber(), "牵犬师结业证书", handlerDiploma.getCertificateCode(),"85"); //GYH1 modified
		Date issueDate = handlerDiploma.getIssueDate();
        String date = DateUtils.formatDate(issueDate, "yyyy年M月d日");
        handlerDiploma.setIssDate(date);
        Member member =  memberDao.getByMemberCode(handlerDiploma.getMemberCode());
        handlerDiploma.setNameEn(member.getNameEn());
		return handlerDiploma;
	}

	/**
	 * 训犬师打印
	 * @Author chaixueteng
	 * @2016年9月3日下午4:46:47
	 */
	@Transactional(readOnly = false)
	public HandlerDiploma trainPrint(HandlerDiploma handlerDiploma) {
		SysContext sysContext = new SysContext(null,null,null);
		sysContext.noStateExecute(sysContext,"训犬师结业证书打印",handlerDiploma.getMemberCode(),"handler_diploma",handlerDiploma.getId(),handlerDiploma.getRunningNumber(),(str)->{});
		handlerDiploma.setPrintState("1");
		dao.resetPrint(handlerDiploma);
		//推送消息
		expressQueueService.push(handlerDiploma.getMemberCode(), handlerDiploma.getRunningNumber(), "训犬师结业证书", handlerDiploma.getCertificateCode(),null); // GYH2 TODO
		Date issueDate = handlerDiploma.getIssueDate();
        String date = DateUtils.formatDate(issueDate, "yyyy年M月d日");
        handlerDiploma.setIssDate(date);
		return handlerDiploma;
	}

	/**
	 * 得到培训机构输送的学员数
	 * @Author chaixueteng
	 * @2016年9月3日下午5:52:57
	 */
	public int getCount(String schoolNameCn) {
		return dao.getCount(schoolNameCn);
	}
	
	/**
	 * 
	 * @description: 牵犬师业务校验
	 * @author: laiguanglong
	 * @date: 2016年9月19日 上午10:11:23
	 */
	public void validateBusiness(HandlerDiploma po){
		//校验重复订单
		HandlerDiploma example = new HandlerDiploma();
		example.setMemberCode(po.getMemberCode());
		List<HandlerDiploma> list = findList(example);
		if(list.size()!=0){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"该会员已申请牵犬师资格证明");
		}
	}
}