package com.cku.oa.groomer.web;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.logUtil.JSONObjectUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.annotation.MultiSubmit;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.entity.GroomerShow;
import com.cku.oa.groomer.entity.GroomerShowReferee;
import com.cku.oa.groomer.service.GroomerShowRefereeService;
import com.cku.oa.groomer.service.GroomerShowService;
import com.cku.oa.trainschool.dao.TrainingInstitutionDao;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;



/**
 * 美容师活动Controller
 * @author cxt
 * @version 2016-07-14
 */
@Controller
@RequestMapping(value = "${adminPath}/groomer/groomerShow")
public class GroomerShowController extends BaseController {

	@Autowired
	private GroomerShowService groomerShowService;
	@Autowired
	private GroomerShowRefereeService showRefereeService;
	@Autowired
	private TrainingInstitutionDao trainingInstitutionDao;
	
	@ModelAttribute
	public GroomerShow get(@RequestParam(required=false) String id) {
		GroomerShow entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = groomerShowService.get(id);
		}
		if (entity == null){
			entity = new GroomerShow();
		}
		return entity;
	}
	
	@RequiresPermissions("groomer:groomerShow:view")
	@RequestMapping(value = {"list", ""})
	public String list(GroomerShow groomerShow, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<GroomerShow> page = groomerShowService.findPage(new Page<GroomerShow>(request, response), groomerShow);
		request.setAttribute("date", new Date());
		model.addAttribute("page", page);
		return "oa/groomer/groomerShowList";
	}

	/**
	 * 查看
	 * @Author chaixueteng
	 * @2016年8月27日上午11:02:17
	 */
	@RequiresPermissions("groomer:groomerShow:view")
	@RequestMapping(value = "view")
	public String view(GroomerShow groomerShow, Model model) throws ZAException {
		List<GroomerShowReferee> showRefereeList = showRefereeService.findAllShowReferee();
		model.addAttribute("showRefereeList", showRefereeList);
		// 开放状态的合作学校
		TrainingInstitution ti = new TrainingInstitution();
		User user = new User();
		user.setLoginType("1");
		ti.setUser(user);
		List<TrainingInstitution> findList = trainingInstitutionDao.findGroomerList(ti);
		model.addAttribute("schools", findList);
		model.addAttribute("groomerShow", groomerShow);
		return "oa/groomer/groomerShowView";
	}

	@RequiresPermissions("groomer:groomerShow:view")
	@RequestMapping(value = "form")
	public String form(GroomerShow groomerShow, Model model) throws ZAException {
		List<GroomerShowReferee> showRefereeList = showRefereeService.findAllShowReferee();
		// 开放状态的合作学校
		TrainingInstitution ti = new TrainingInstitution();
		User user = new User();
		user.setLoginType("1");
		user.setLoginFlag("1");
		ti.setUser(user);
		List<TrainingInstitution> findList = trainingInstitutionDao.findGroomerList(ti);
		model.addAttribute("showRefereeList", showRefereeList);
		model.addAttribute("schools", findList);
		model.addAttribute("groomerShow", groomerShow);
		return "oa/groomer/groomerShowForm";
	}

	@RequiresPermissions("groomer:groomerShow:view")
	@RequestMapping(value = "save")
	@ResponseBody
	@MultiSubmit(timeout = 5)
	public ResultDto<String> save(GroomerShow groomerShow){
		logger.info("保存美容活动入参 groomerShow : {}", JSONObjectUtils.toJsonString(groomerShow));
		try {
			restBeanValidator(groomerShow);
			boolean hasPermission;
			if (!StringUtils.isEmpty(groomerShow.getId())) {
				hasPermission = SecurityUtils.getSubject().isPermitted("groomer:groomerShow:edit");
			} else {
				hasPermission = SecurityUtils.getSubject().isPermitted("groomer:groomerShow:add");
			}
			Set<String> testLevelSet = Arrays.stream(groomerShow.getTestLevel().split(","))
					.collect(Collectors.toCollection(LinkedHashSet::new));
			StringBuilder testLevelString = new StringBuilder();
			int i = 0;
			for (String s : testLevelSet) {
				if (i == testLevelSet.size()-1) {
					testLevelString.append(s);
				} else {
					testLevelString.append(s).append(",");
				}
				i++;
			}
			groomerShow.setTestLevel(testLevelString.toString());
			logger.info("----------------- testLevelString : {}", JSONObjectUtils.toJsonString(testLevelString));
			if (hasPermission) {
				//转义符号乱码
				String s = StringEscapeUtils.unescapeHtml4(groomerShow.getShowName());
				groomerShow.setShowName(s);
				groomerShowService.save(groomerShow);
			}
		} catch (Exception ex) {
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, ex.getMessage());
		}
		return ResultDto.success(groomerShow.getId());
	}

	
	@RequiresPermissions("groomer:groomerShow:delete")
	@RequestMapping(value = "delete")
	public String delete(GroomerShow groomerShow, RedirectAttributes redirectAttributes) {
		groomerShowService.delete(groomerShow);
		addMessage(redirectAttributes, "删除美容师活动成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerShow/?repage";
	}

	
	/**
	 * 报名
	 * @Author chaixueteng
	 * @2016年7月14日下午12:53:45
	 */
	@RequiresPermissions("groomer:groomerShow:register")
	@RequestMapping(value="registerForm")
	public String registerPage(GroomerShow  groomerShow,GroomerRegister groomerRegister,Model model){
		TrainingInstitution ti = new TrainingInstitution();
		List<TrainingInstitution> findList = trainingInstitutionDao.findGroomerList(ti);
		model.addAttribute("findList", findList);
		model.addAttribute("groomerShow", groomerShow );
		model.addAttribute("groomerRegister", groomerRegister );
		model.addAttribute("groomerShowTypeMap",groomerShowService.getShowTypeMap(groomerShow.getShowCode()));
		return "oa/groomer/groomerShowRegisterForm";
	}
	
	/**
	 * 报名(团队赛)
	 * @Author chaixueteng
	 * @2016年7月14日下午12:53:45
	 */
	@RequiresPermissions("groomer:groomerShow:register")
	@RequestMapping(value="registerTTForm")
	public String registerTTPage(GroomerShow  groomerShow,GroomerRegister groomerRegister,Model model){
		model.addAttribute("groomerShow", groomerShow );
		model.addAttribute("groomerRegister", groomerRegister );
		return "oa/groomer/groomerShowRegisterTTForm";
	}
	/**
	 * 根据赛事编号查询级别
	 * @Author chaixueteng
	 * @2016年7月19日下午3:15:14
	 */
	@RequestMapping(value = "/getShowType")
    public void getShowType(HttpServletRequest request, HttpServletResponse response) {
	    String showCode = request.getParameter("showCode");
        try {
        	response.setContentType("text/Xml;charset=utf-8");
        	String str =groomerShowService.getShowType(showCode);
            response.getWriter().write(str);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
	/**
	 * 查询赛事信息
	 * @Author chaixueteng
	 * @2016年7月19日下午3:15:14
	 */
	@RequestMapping(value = "/getShowMessage")
    public void getShowMessage(HttpServletRequest request, HttpServletResponse response) {
	    String id = request.getParameter("id");
        try {
        	response.setContentType("text/Xml;charset=utf-8");
        	String  str =groomerShowService.getShowMessage(id);
            response.getWriter().write(str);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
	
	/**
	 * 重复赛事校验
	 * @Author chaixueteng
	 * @2016年7月19日下午3:15:14
	 */
	@RequestMapping(value = "/codeCheck")
	@ResponseBody
    public String codeCheck(HttpServletRequest request, HttpServletResponse response) {
	    String showCode = request.getParameter("showCode");
	    String id = request.getParameter("id");
    	String b =groomerShowService.codeCheck(showCode,id);
		return b;
    }
	
	
	
	/**
	 * 美容报名统计
	 * @Author chaixueteng
	 * @2016年9月8日下午2:52:39
	 */
	@RequestMapping(value="getShowStatictices")
	public String getShowStatistics(GroomerShow groomerShow, HttpServletRequest request, HttpServletResponse response, Model model){
		Page<GroomerShow> page = groomerShowService.findStatisticsPage(new Page<GroomerShow>(request, response), groomerShow);
		model.addAttribute("allShows",page.getList().size());
		List<GroomerShow> list = page.getList();
		long allFee=0;
		long allMemberNum=0;
		for (GroomerShow groomerShow2 : list) {
			allFee += groomerShow2.getAllFeeNum();
			allMemberNum+=groomerShow2.getMemberNum();
		}
		model.addAttribute("allFee",allFee);
		model.addAttribute("allMemberNum",allMemberNum);
		model.addAttribute("page", page);
		return "oa/groomer/groomerStatistics";
	}
	
}