package com.cku.oa.finance.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.finance.entity.SaFinanceSubjectMapping;
import com.cku.oa.finance.dao.SaFinanceSubjectMappingDao;

/**
 * 财务映射表Service
 *
 * @author 财务映射表
 * @version 2019-09-23
 */
@Service
@Transactional(readOnly = true)
public class SaFinanceSubjectMappingService extends CrudService<SaFinanceSubjectMappingDao, SaFinanceSubjectMapping> {

	public List<SaFinanceSubjectMapping> findAllBusinessList() {
		return dao.findAllBusinessList();
	}

	public SaFinanceSubjectMapping get(String id) {
		return super.get(id);
	}

	public List<SaFinanceSubjectMapping> findList(SaFinanceSubjectMapping saFinanceSubjectMapping) {
		return super.findList(saFinanceSubjectMapping);
	}

	public List<SaFinanceSubjectMapping> findListBySysOfficeCode(String code) {
		return dao.findListByDeptCode(code);
	}

	public Page<SaFinanceSubjectMapping> findPage(Page<SaFinanceSubjectMapping> page, SaFinanceSubjectMapping saFinanceSubjectMapping) {
		return super.findPage(page, saFinanceSubjectMapping);
	}

	@Transactional(readOnly = false)
	public void save(SaFinanceSubjectMapping saFinanceSubjectMapping) {
		super.save(saFinanceSubjectMapping);
	}

	@Transactional(readOnly = false)
	public void delete(SaFinanceSubjectMapping saFinanceSubjectMapping) {
		super.delete(saFinanceSubjectMapping);
	}

}