/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.entity;

import java.util.Date;
import java.util.List;

import org.hibernate.validator.constraints.Length;

import com.cku.oa.statistics.vo.RegionVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import com.thinkgem.jeesite.modules.sys.entity.User;

/**
 * 会员支付流水Entity
 * 
 * @author lyy
 * @version 2016-07-18
 */
public class MemberAccount extends DataEntity<MemberAccount> {
	private static final long serialVersionUID = 1L;
	@ExcelField(title = "会员号", align = 2, sort = 2)
	private String memberCode; // 会员号
	private String businessId; // 业务表id
	private String chargingItemId; // 付款条目，参考payment_item表。如果payment_item为空，代表账号充值
	private Integer chargingItemNum; // 付款条目数量
	@ExcelField(title = "实付金额", align = 2, sort = 4)
	private String paymentAmount; // 实付金额
	private String price; // 付款服务的价格
	@ExcelField(title = "支付方式", align = 2, sort = 7)
	private String paymentWay; // 参见数据字典表：代表的是支付宝充值，赛场收费，建行网银充值等
	@ExcelField(title = "流水号", align = 2, sort = 1)
	private String runningNumber; // 流水号
	private String paymentState; // 付款状态 3为反向充值， 旧单为3。
	private String outTradeNo; // 支付宝返回的参数out_trade_no
	@ExcelField(title = "缴费时间", align = 2, sort = 8)
	private Date paymentTime; // 支付时间
	private Date paymentTimeStart;
	private Date paymentTimeEnd;
	@ExcelField(title = "备注", align = 2, sort = 9)
	private String paymentRemarks; // 付款备注
	@ExcelField(title = "操作人", align = 2, sort = 10)
	private User updateByName; // update_by_name
	private String alipayS; // 支付宝的参数
	@ExcelField(title = "姓名", align = 2, sort = 3)
	private String memberName;
	@ExcelField(title = "收支类型", align = 2, sort = 6)
	private String chargingItemName;
	private String chargingItemOfficeId;
	@ExcelField(title = "部门", align = 2, sort = 5)
	private String chargingItemOfficeName;
	@ExcelField(title = "付款会员号", align = 2, sort = 12)
	private String cmember;
	private String orgmember;
	@ExcelField(title = "账户余额", align = 2, sort = 11)
	private String balanceMoney;
	private String voucherCode; // 凭证号
	private String runningNumberReverse;
	private String searcheType;
	private String type;
	private String businessRefundState;// '业务退款状态 1退款待审核，2审核不通过，3审核通过';

	private String source;

	private String province;
	private List<RegionVo> regions;
	
	private String balanceMoneyReal;

	private String registerProvince;
	
	private String registerCity;

	/**
	 * 判断该条数据是否为当前用户
	 */
	private Boolean owner;

	/**
	 * 订单作废
	 * @return
	 */
	private String orderCancelStatus;

	public String getRegisterProvince() {
		return registerProvince;
	}

	public void setRegisterProvince(String registerProvince) {
		this.registerProvince = registerProvince;
	}

	public String getRegisterCity() {
		return registerCity;
	}

	public void setRegisterCity(String registerCity) {
		this.registerCity = registerCity;
	}

	public String getBalanceMoneyReal() {
		return balanceMoneyReal;
	}

	public void setBalanceMoneyReal(String balanceMoneyReal) {
		this.balanceMoneyReal = balanceMoneyReal;
	}

	public MemberAccount() {
		super();
	}

	public MemberAccount(String id) {
		super(id);
	}

	@Length(min = 0, max = 60, message = "会员号长度必须介于 0 和 60 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 64, message = "业务表id长度必须介于 0 和 64 之间")
	public String getBusinessId() {
		return businessId;
	}

	public void setBusinessId(String businessId) {
		this.businessId = businessId;
	}

	@Length(min = 0, max = 64, message = "付款条目，参考payment_item表。如果payment_item为空，代表账号充值长度必须介于 0 和 64 之间")
	public String getChargingItemId() {
		return chargingItemId;
	}

	public void setChargingItemId(String chargingItemId) {
		this.chargingItemId = chargingItemId;
	}

	public Integer getChargingItemNum() {
		return chargingItemNum;
	}

	public void setChargingItemNum(Integer chargingItemNum) {
		this.chargingItemNum = chargingItemNum;
	}

	public String getPaymentAmount() {
		return paymentAmount;
	}

	public void setPaymentAmount(String paymentAmount) {
		this.paymentAmount = paymentAmount;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	@Length(min = 0, max = 64, message = "参见数据字典表：代表的是支付宝充值，赛场收费，建行网银充值等长度必须介于 0 和 64 之间")
	public String getPaymentWay() {
		return paymentWay;
	}

	public void setPaymentWay(String paymentWay) {
		this.paymentWay = paymentWay;
	}

	@Length(min = 0, max = 100, message = "流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 0, max = 20, message = "付款状态长度必须介于 0 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@Length(min = 0, max = 50, message = "支付宝返回的参数out_trade_no长度必须介于 0 和 50 之间")
	public String getOutTradeNo() {
		return outTradeNo;
	}

	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTimeStart() {
		return paymentTimeStart;
	}

	public void setPaymentTimeStart(Date paymentTimeStart) {
		this.paymentTimeStart = paymentTimeStart;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTimeEnd() {
		return paymentTimeEnd;
	}

	public void setPaymentTimeEnd(Date paymentTimeEnd) {
		this.paymentTimeEnd = paymentTimeEnd;
	}

	@Length(min = 0, max = 255, message = "付款备注长度必须介于 0 和 255 之间")
	public String getPaymentRemarks() {
		return paymentRemarks;
	}

	public void setPaymentRemarks(String paymentRemarks) {
		this.paymentRemarks = paymentRemarks;
	}

	public User getUpdateByName() {
		return updateByName;
	}

	public void setUpdateByName(User updateByName) {
		this.updateByName = updateByName;
	}

	@Length(min = 0, max = 100, message = "支付宝的参数长度必须介于 0 和 100 之间")
	public String getAlipayS() {
		return alipayS;
	}

	public void setAlipayS(String alipayS) {
		this.alipayS = alipayS;
	}

	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	public String getChargingItemName() {
		return chargingItemName;
	}

	public void setChargingItemName(String chargingItemName) {
		this.chargingItemName = chargingItemName;
	}

	public String getChargingItemOfficeName() {
		return chargingItemOfficeName;
	}

	public void setChargingItemOfficeName(String chargingItemOfficeName) {
		this.chargingItemOfficeName = chargingItemOfficeName;
	}

	public String getChargingItemOfficeId() {
		return chargingItemOfficeId;
	}

	public void setChargingItemOfficeId(String chargingItemOfficeId) {
		this.chargingItemOfficeId = chargingItemOfficeId;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getCmember() {
		return cmember;
	}

	public void setCmember(String cmember) {
		this.cmember = cmember;
	}

	public String getOrgmember() {
		return orgmember;
	}

	public void setOrgmember(String orgmember) {
		this.orgmember = orgmember;
	}

	public String getBalanceMoney() {
		return balanceMoney;
	}

	public void setBalanceMoney(String balanceMoney) {
		this.balanceMoney = balanceMoney;
	}

	public String getSearcheType() {
		return searcheType;
	}

	public void setSearcheType(String searcheType) {
		this.searcheType = searcheType;
	}

	public String getRunningNumberReverse() {
		return runningNumberReverse;
	}

	public void setRunningNumberReverse(String runningNumberReverse) {
		this.runningNumberReverse = runningNumberReverse;
	}

	public String getVoucherCode() {
		return voucherCode;
	}

	public void setVoucherCode(String voucherCode) {
		this.voucherCode = voucherCode;
	}

	public String getBusinessRefundState() {
		return businessRefundState;
	}

	public void setBusinessRefundState(String businessRefundState) {
		this.businessRefundState = businessRefundState;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public List<RegionVo> getRegions() {
		return regions;
	}

	public void setRegions(List<RegionVo> regions) {
		this.regions = regions;
	}

	public Boolean getOwner() {
		return owner;
	}

	public void setOwner(Boolean owner) {
		this.owner = owner;
	}

	public String getOrderCancelStatus() {
		return orderCancelStatus;
	}

	public void setOrderCancelStatus(String orderCancelStatus) {
		this.orderCancelStatus = orderCancelStatus;
	}
}