/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentChargingItemGroup;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * OA订单录入组合收费项DAO接口
 *
 * @author 赖广龙
 * @version 2017-06-23
 */
@MyBatisDao
public interface PaymentChargingItemGroupDao extends CrudDao<PaymentChargingItemGroup> {

	List<String> getPaymentChargingItemIdsAndBizIdByGroupId(
			@Param("paymentChargingItemGroupId") String paymentChargingItemGroupId);

	List<String> departmentList();

	List<String> getPaymentChargingItemIdsByPaymentChargingItemGroupId(
			@Param("paymentChargingItemGroupId") String paymentChargingItemGroupId);
	
	List<PaymentChargingItem> getPaymentChargingItemsByPaymentChargingItemGroupId(
			@Param("paymentChargingItemGroupId") String paymentChargingItemGroupId);

	List<PaymentChargingItem> findPaymentChargingItemById(@Param("groupId") String groupId);
	
	List<PaymentChargingItem> findPaymentChargingItemFuzzy(@Param("fuzzyGroupId") String fuzzyGroupId);
}