package com.cku.oa.dog.service;

import java.util.List;

import net.sf.json.JSONObject;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogSemenDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogSemen;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.sys.service.LoginServerService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 犬只精子Service
 *
 * @author lgl
 * @version 2017-08-28
 */
@Service
@Transactional(readOnly = true)
public class DogSemenService extends CrudService<DogSemenDao, DogSemen> {

    @Autowired
    private DogDao dogDao;
    @Autowired
    private DogTypeService dogTypeService;
    @Autowired
    private LoginServerService loginServerService;

    public DogSemen get(String id) {
        return super.get(id);
    }

    public List<DogSemen> findList(DogSemen dogSemen) {
    	if(StringUtils.isBlank(dogSemen.getDogBreed())){
    		if(StringUtils.isBlank(dogSemen.getDogBreedLike())){
    			//根据当前登录端查询犬种
    			dogSemen.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
    		}else{
        		dogSemen.getSqlMap().put("dogBreedMap", " ='"+dogSemen.getDogBreedLike()+"'");
    		}
    	}else{
    		dogSemen.getSqlMap().put("dogBreedMap", " ='"+dogSemen.getDogBreed()+"'");
    	}
    	return super.findList(dogSemen);
    }

    public Page<DogSemen> findPage(Page<DogSemen> page, DogSemen dogSemen) {
    	if(StringUtils.isBlank(dogSemen.getDogBreed())){
    		if(StringUtils.isBlank(dogSemen.getDogBreedLike())){
    			//根据当前登录端查询犬种
    			dogSemen.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
    		}else{
        		dogSemen.getSqlMap().put("dogBreedMap", " ='"+dogSemen.getDogBreedLike()+"'");
    		}
    	}else{
    		dogSemen.getSqlMap().put("dogBreedMap", " ='"+dogSemen.getDogBreed()+"'");
    	}
    	return super.findPage(page, dogSemen);
    }

    @Transactional(readOnly = false)
    public void save(DogSemen dogSemen) {
        super.save(dogSemen);
    }

    @Transactional(readOnly = false)
    public void delete(DogSemen dogSemen) {
        super.delete(dogSemen);
    }

    public void setDogInfo(String dogId, JSONObject data) {
        Dog dog = dogDao.get(dogId);
        data.put("dogId", getString(dog.getId()));
        data.put("pedigreeCertified", getString(dog.getPedigreeCertifiedCode()));
        data.put("dogChip", getString(dog.getIdentificationFlag()));
        String dogBreed = "";
        if (StringUtils.isNotBlank(dog.getDogBreed())) {
            DogType dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
            if (dogType != null) {
                dogBreed = dogType.getBreedCnName();
            }
        }
        data.put("dogBreed", getString(dogBreed));
        data.put("dogName", getString(dog.getNameEn()));
        data.put("dogOwner", getString(dog.getDogOwner()));
    }

    private String getString(String str) {
        return str == null ? "" : str;
    }
}