package com.cku.oa.dog.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * xxEntity
 * 
 * @author zxy
 * @version 2020-07-10
 */
public class DogVideoAppraisalFile extends DataEntity<DogVideoAppraisalFile> {

	private static final long serialVersionUID = 1L;
	private String fileType; // 文件类型 1:图片 2:视频
	private String fildId; // fild_id
	private String appraisalId; // 文件id
	private String fileSort; // 文件排序

	private String businessCode;

	public DogVideoAppraisalFile() {
		super();
	}

	public DogVideoAppraisalFile(String id) {
		super(id);
	}

	@Length(min = 0, max = 1, message = "文件类型 1:图片 2:视频长度必须介于 0 和 1 之间")
	public String getFileType() {
		return fileType;
	}

	public void setFileType(String fileType) {
		this.fileType = fileType;
	}

	@Length(min = 0, max = 100, message = "fild_id长度必须介于 0 和 100 之间")
	public String getFildId() {
		return fildId;
	}

	public void setFildId(String fildId) {
		this.fildId = fildId;
	}

	@Length(min = 0, max = 100, message = "文件id长度必须介于 0 和 100 之间")
	public String getAppraisalId() {
		return appraisalId;
	}

	public void setAppraisalId(String appraisalId) {
		this.appraisalId = appraisalId;
	}

	@Length(min = 0, max = 16, message = "文件排序长度必须介于 0 和 16 之间")
	public String getFileSort() {
		return fileSort;
	}

	public void setFileSort(String fileSort) {
		this.fileSort = fileSort;
	}

	public String getBusinessCode() {
		return businessCode;
	}

	public void setBusinessCode(String businessCode) {
		this.businessCode = businessCode;
	}

}