package com.cku.interceptor;

import java.sql.Connection;
import java.util.Properties;

import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.common.utils.StringUtils;

import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.update.Update;

@Intercepts({ @Signature(type = StatementHandler.class, method = "prepare", args = { Connection.class }) })
public class SQLStatsInterceptor implements Interceptor {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Override
	public Object intercept(Invocation invocation) throws Throwable {
		try {
			StatementHandler statementHandler = (StatementHandler) invocation.getTarget();
			BoundSql boundSql = statementHandler.getBoundSql();
			String originalSql = boundSql.getSql();
			if (StringUtils.isNotBlank(originalSql) && originalSql.contains("sys_member")
					&& originalSql.contains("avatar")) {
				Statement statement = CCJSqlParserUtil.parse(originalSql);
				if (statement instanceof Update || statement instanceof Insert) {
					if (statementHandler.getParameterHandler().getParameterObject() instanceof Member) {
						Member member = (Member) statementHandler.getParameterHandler().getParameterObject();
						logger.info("===$===mybatis intercept sql sys_member avatar:{},parameter:{}",
								originalSql.replaceAll("[\\t\\n\\r]", ""), member.toString());
					} else {
						logger.info("===#===mybatis intercept sql sys_member avatar:{},parameter:{}",
								originalSql.replaceAll("[\\t\\n\\r]", ""),
								statementHandler.getParameterHandler().getParameterObject());
					}
				}
			} else if (StringUtils.isNotBlank(originalSql) && originalSql.contains("dog_birth_certificate")
					&& originalSql.contains("add_user")) {
				Statement statement = CCJSqlParserUtil.parse(originalSql);
				if (statement instanceof Update || statement instanceof Insert) {
					if (statementHandler.getParameterHandler().getParameterObject() instanceof DogBirthCertificate) {
						DogBirthCertificate dogBirthCertificate = (DogBirthCertificate) statementHandler
								.getParameterHandler().getParameterObject();
						logger.info("===$===mybatis intercept sql dogBirthCertificate:{},parameter:{}",
								originalSql.replaceAll("[\\t\\n\\r]", ""), dogBirthCertificate.toString());
					} else {
						logger.info("===#===mybatis intercept sql dogBirthCertificate:{},parameter:{}",
								originalSql.replaceAll("[\\t\\n\\r]", ""),
								statementHandler.getParameterHandler().getParameterObject());
					}
				}
			}
		} catch (Exception e) {
			// e.printStackTrace();
		}
		return invocation.proceed();
	}

	@Override
	public Object plugin(Object target) {
		return Plugin.wrap(target, this);
	}

	@Override
	public void setProperties(Properties properties) {
//        String dialect = properties.getProperty("dialect");
//        logger.info("mybatis intercept dialect:{}", dialect);
	}
}