<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>登记卡管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctxDc}/dogBirthCertificate/">登记卡管理</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogBirthCertificate" action="${ctxDc}/dogBirthCertificate/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>登记卡编号：</label>
				<form:input path="birthCerRegCode" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>配种证明编号：</label>
				<form:input path="fmdogBreedCertifiedCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>犬主/繁殖人：</label>
				<form:input path="dogOwenr" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>付款的状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('dog_birth_certificate_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
		</ul>
		<ul class="ul-form">
			<li><label>加急状态：</label>
				<form:select path="urgent" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('urgent_status')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>区域：</label>
                <form:select path="agency" class="input-medium">
                	<form:option value="" label="全部"/>
                	<form:options items="${agencyList}" itemLabel="name" itemValue="id" htmlEscape="false"/>
                </form:select>
			</li>
			<li><label>申请时间：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogBirthCertificate.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogBirthCertificate.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>打印类型：</label>
				<form:select path="newbornPrintType" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('print_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>打印状态：</label>
                <form:select path="printType" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('birth_certificate_print_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
			<li><label>芯片号：</label>
				<form:input path="identificationFlag" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>登记卡编号</th>
				<th>配种证明编号</th>
				<th>性别</th>
				<th>英文犬名</th>
				<th>犬种代码</th>
				<th>出生日期</th>
				<th>芯片号码</th>
				<th>繁殖人</th>
				<th>加急</th>
				<th>抵扣</th>
				<th>缴费状态</th>
				<th>缴费日期</th>
				<th>业务状态</th>
				<th>管理</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogBirthCertificate">
			<tr>
				<td>
					${fns:escapeHtml(dogBirthCertificate.birthCerRegCode)}
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.fmdogBreedCertifiedCode)}
				</td>
				<td>
					${fns:getDictLabel(dogBirthCertificate.dogGender, 'dog_gender', '')}
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.dogEnName)}
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.dogBreed)}
				</td>
				<td>
					<fmt:formatDate value="${dogBirthCertificate.dogBirthday}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.identificationFlag)}
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.breeder)}
				</td>
				<td style="color:${dogBirthCertificate.urgent=='1'?'#F00':''}">
					${fns:getDictLabel(dogBirthCertificate.urgent, 'urgent_status', '')}
				</td>
				<td>
					<c:if test="${fns:escapeHtml(dogBirthCertificate.deduction)=='0'}">
							<font>否</font>
					</c:if>
					<c:if test="${fns:escapeHtml(dogBirthCertificate.deduction)=='1'}">
						<font color="red">是</font>	
					</c:if>
				</td>
				<td style="color:${dogBirthCertificate.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(dogBirthCertificate.paymentState, 'user_payment_state', '未缴费')}
				</td>
				<td style="color:${empty dogBirthCertificate.snCode?'#F00':'#000'}">
                    <fmt:formatDate value="${dogBirthCertificate.paymentTime}" pattern="yyyy-MM-dd"/>
                </td>
				<td style="color:#000">
					<c:if test="${dogBirthCertificate.paymentState=='2'}">
					<c:choose>
						<c:when test="${dogBirthCertificate.reviewState=='0'}">
							${fns:getDictLabel(dogBirthCertificate.reviewState, 'dog_birth_certificate_review_state', '')}
						</c:when>
						<c:when test="${dogBirthCertificate.reviewState=='2'}">
							${fns:getDictLabel(dogBirthCertificate.reviewState, 'dog_birth_certificate_review_state', '')}
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(dogBirthCertificate.reviewState, 'dog_birth_certificate_review_state', '')}
						</c:otherwise>
					</c:choose>
					</c:if>
    			</td>
				<td>
					${dogBirthCertificate.businessState}
				</td>
				<td>
    				<a href="${ctxDc}/dogBirthCertificate/form?id=${dogBirthCertificate.id}">查看</a>
    			</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>