<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>合作学校管理</title>
	<meta name="decorator" content="default"/>
	
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/trainschool/trainingInstitution/handlerView?id=${trainingInstitution.id}">培训合作学校查看</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="trainingInstitution"  class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>	
		<div class="control-group">
			<label class="control-label">机构中文：</label>
			<div class="controls">
				${fns:escapeHtml(trainingInstitution.schoolNameCn)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">机构英文：</label>
			<div class="controls">
				${fns:escapeHtml(trainingInstitution.schoolNameEn)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">机构英文缩写：</label>
			<div class="controls">
				${fns:escapeHtml(trainingInstitution.schoolShortName)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">负责人会员号：</label>
			<div class="controls">
				${fns:escapeHtml(trainingInstitution.memberCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">负责人：</label>
			<div class="controls">
				${fns:escapeHtml(trainingInstitution.responsibler)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">联系电话：</label>
			<div class="controls">
				${fns:escapeHtml(trainingInstitution.telephone)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">省：</label>
			<div class="controls">
				${fns:escapeHtml(trainingInstitution.province)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">市：</label>
			<div class="controls">
				${fns:escapeHtml(trainingInstitution.city)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">街道：</label>
			<div class="controls">
				${fns:escapeHtml(trainingInstitution.street)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">地址：</label>
			<div class="controls">
				${fns:escapeHtml(trainingInstitution.address)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">开始时间：</label>
			<div class="controls">
				<fmt:formatDate value="${trainingInstitution.startDate}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">结束时间：</label>
			<div class="controls">
				<fmt:formatDate value="${trainingInstitution.endDate}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">学校类别：</label>
			<div class="controls">
			 ${fns:getDictLabel(trainingInstitution.schoolType,'school_type','')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				${fns:escapeHtml(trainingInstitution.remarks)}
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>