<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>优惠劵管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/coupon/sysCoupon/">优惠劵列表</a></li>
		<li class="active"><a href="${ctx}/coupon/sysCoupon/form?id=${sysCoupon.id}">优惠劵<shiro:hasPermission name="coupon:sysCoupon:edit">${not empty sysCoupon.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="coupon:sysCoupon:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="sysCoupon" action="${ctx}/coupon/sysCoupon/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">优惠劵名称：</label>
			<div class="controls">
				<form:input path="couponName" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">面值：</label>
			<div class="controls">
				<form:input path="facePrice" htmlEscape="false" maxlength="11" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">生效期：</label>
			<c:if test="${sysCoupon.effectiveDate==null}">
				<div class="controls">
					<input name="effectiveDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
						value="${sysCoupon.effectiveDate}"
						onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/> 
				</div>
			</c:if>
			<c:if test="${sysCoupon.effectiveDate!=null}">
				<div class="controls">
					<input name="effectiveDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
						value="<fmt:formatDate value="${sysCoupon.effectiveDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
						onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/> 
				</div>
			</c:if>
		</div>
		<div class="control-group">
			<label class="control-label">有效期：</label>
			<c:if test="${sysCoupon.validDate==null}">
				<div class="controls">
					<input name="validDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
						value="${sysCoupon.validDate}"
						onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/> 
				</div>
			</c:if>
			<c:if test="${sysCoupon.validDate!=null}">
				<div class="controls">
					<input name="validDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
						value="<fmt:formatDate value="${sysCoupon.validDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
						onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/> 
				</div>
			</c:if>
		</div>
		<div class="control-group">
			<label class="control-label">说明：</label>
			<div class="controls">
				<form:input path="explains" htmlEscape="false" maxlength="150" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">面向折扣对象：</label>
			<div class="controls">
				<form:input path="target" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="coupon:sysCoupon:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>