<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展子表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#btnImport").click(function(){
				$.jBox($("#importBox").html(), {title:"犬展导入", buttons:{"关闭":true}, 
					bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
			});
			
			$("#btnRefreshLastYear").click(function(){
				//技术部后台方法，处理上一年遗留犬展刷新排行榜
				window.location.href = "${ctx}/results/showResults/refreshLastYear";
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		//悬浮提示插件
		$(document).tooltip();
		function btnRefreshRanking(id){
				top.$.jBox.confirm("确认要统计该场犬展积分并刷新排行榜吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						loading('正在刷新，请稍等...');
						 $.ajax({
								type: "GET",
				                dataType:"json",
				                url:"${ctx}/results/showResults/updateShowResult?id="+id,
				                async: true,
				                error: function(request, textStatus, errorThrown) {
				                	closeLoading();
				                    alert("请求失败!");
				                   
				                },
				                success: function(data) {
				                	if(data.rc == 1){
										closeLoading();
										alert("统计失败："+data.msg);
				                	}else{
				                		 closeLoading();
				                		 alert("统计成功！");
				                		 $("#searchForm").submit();
				                	}
				                }
							});
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
		};
	</script>
</head>
<body>
	<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/show.child/childShows/import" method="post" enctype="multipart/form-data"
			class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
			<a href="${ctx}/show.child/childShows/import/template">下载模板</a>
		</form>
	</div>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/show.child/childShows/">犬展列表</a></li>
		<shiro:hasPermission name="show.child:childShows:edit"><li><a href="${ctx}/show.child/childShows/add">录入犬展信息</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="childShows" action="${ctx}/show.child/childShows/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>犬展编号：</label>
				<form:input path="showCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>犬展名称：</label>
				<form:input path="showName" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>犬展序号：</label>
				<form:input path="serialNumber" htmlEscape="false" maxlength="5" class="input-mini"/>
			</li>
		</ul>
		<ul class="ul-form">
			<li><label>主办方：</label>
				<form:select path="mainShows.organizer" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('show_organizer')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>积分状态：</label>
				<form:select path="statisticsState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('show_statistics_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="btns"><input id="btnImport" class="btn btn-primary" type="button" value="导入犬展信息"/></li>
			<c:if test="${btnRefreshLastYear}">
				<li class="btns">
					 <input id="btnRefreshLastYear" class="btn btn-primary" type="button"  onclick="" value="技术部-统计上年遗留犬展"/> 
				</li>
			</c:if>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>犬展编号</th>
				<th>犬展名称</th>
				<th>犬展报名截止时间</th>
				<th>犬展地点</th>
				<th>开始日期</th>
				<th>结束日期</th>
				<th>报名费</th>
				<th>报名</th>
				<th>举办方式</th>
				<th>主办</th>
				<th>生成成绩</th>
				<th>统计积分</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="childShows">
			<tr>
				<td>
					${fns:escapeHtml(childShows.showCode)}
				</a></td>
				<td>
					${fns:escapeHtml(childShows.showName)} - ${fns:escapeHtml(childShows.serialNumber)}
				</td>
				<td>
					<fmt:formatDate value="${childShows.mainShows.closingTime}" pattern="yyyy-MM-dd HH:ss"/>
				</td>
				<td>
					${fns:escapeHtml(childShows.mainShows.showLocation)}
				</td>
				<td>
					<fmt:formatDate value="${childShows.startTime}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${childShows.endTime}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatNumber value="${fns:escapeHtml(childShows.fee)}" pattern="#,#00.#"/>
				</td>
				<td>
					${fns:getDictLabel(childShows.mainShows.register, 'show_register', '')}
				</td>
				<td>
					${fns:getDictLabel(childShows.mainShows.orgnizeType, 'show_orgnize_type', '')}
				</td>
				<td>
					${fns:getDictLabel(childShows.mainShows.organizer, 'show_organizer', '')}
				</td>
				<td>
					<c:if test="${childShows.winnerState=='1'}">
						${fns:getDictLabel(childShows.statisticsState, 'show_statistics_state', '')}
					</c:if>
					<c:if test="${childShows.winnerState!='1'}">
						<shiro:hasPermission name="contest:contestWinner:createResult">
							<a href="${ctx}/contest/contestWinner/createResult?id=${childShows.id}" onclick="return confirmx('确认要生成该场犬展成绩吗？', this.href)">
						</shiro:hasPermission>
						${fns:getDictLabel(childShows.winnerState, 'show_statistics_state', '')}
						<shiro:hasPermission name="contest:contestWinner:createResult">
							</a>
						</shiro:hasPermission>
					</c:if>
				</td>
				<td>
					<c:if test="${childShows.statisticsState=='1'}">
						${fns:getDictLabel(childShows.statisticsState, 'show_statistics_state', '')}
					</c:if>
					<c:if test="${childShows.statisticsState!='1'}">
						<shiro:hasPermission name="results:showResults:statistics">
						<!-- <a href="${ctx}/results/showResults/updateShowResult?id=${childShows.id}" onclick="return confirmx('确认要统计该场犬展积分并刷新排行榜吗？', this.href)"> -->
						<a onclick="btnRefreshRanking('${childShows.id}')">
							</shiro:hasPermission>
							${fns:getDictLabel(childShows.statisticsState, 'show_statistics_state', '')}
							<shiro:hasPermission name="results:showResults:statistics">
						</a>
						</shiro:hasPermission>
					</c:if>
				</td>
				<td>
				<shiro:hasPermission name="show.child:childShows:view">
					<a href="${ctx}/show.child/childShows/form?id=${childShows.id}">查看</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="show.child:childShows:edit">
					<a href="${ctx}/show.child/childShows/add?id=${childShows.id}">编辑</a>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>