<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>商品管理查看</title>
	<meta name="decorator" content="default"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/shop/shopGoods/">商品列表</a></li>
		<li class="active"><a href="${ctx}/shop/shopGoods/view?id=${shopGoods.id}">商品查看</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="shopGoods" method="post" class="form-horizontal">
		<div class="control-group">
			<label class="control-label">分类：</label>
			<div class="controls">
				<form:input path="className" class="input-xlarge" readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">商品编号：</label>
			<div class="controls">
				<form:input path="code" htmlEscape="false" maxlength="100"  readonly="true" class="input-xlarge required" title="商品编号不能为空！"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">商品名称：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" readonly="true" maxlength="100" class="input-xlarge required" title="商品名称不能为空！"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">商品展示图：</label>
			<div class="controls">
				<c:if test="${shopGoods.image!=null && fn:length(shopGoods.imageList)>0}">
					<c:forEach items="${shopGoods.imageList}" var="img">
						<div class="thumbnail"  style="width: 200px;height: 180px;float:left;">
							<img src="${ctx}/sys/file/image/${img}">
						</div>
					</c:forEach>
				</c:if>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">商品单价：</label>
			<div class="controls">
				<form:input path="price" htmlEscape="false" readonly="true" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">买赠：</label>
			<div class="controls">
					${fns:getDictLabel(shopGoods.buyGifts,'goods_buygifts','')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">返利：</label>
			<div class="controls">
					${fns:getDictLabel(shopGoods.isRebate,'yes_no','')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">运费：</label>
			<div class="controls">
					${fns:getDictLabel(shopGoods.isFreight,'yes_no','')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">分区价格：</label>
			<div class="controls">
					${fns:getDictLabel(shopGoods.isInterval,'yes_no','')}
			</div>
		</div>
	<div id="intervalDetail" style="display:${shopGoods.isInterval=='1'?'block':'none'};">
		<div class="control-group">
			<label class="control-label">分区1价格：</label>
			<div class="controls">
				<form:input path="interval1Price" htmlEscape="false" class="input-xlarge number" min="0"/> <span style="color: red;">0-x*price</span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">分区1数量：</label>
			<div class="controls">
				<form:input path="interval1Num" htmlEscape="false" class="input-xlarge number" min="0"/> <span style="color: red;">0-x</span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">分区2价格：</label>
			<div class="controls">
				<form:input path="interval2Price" htmlEscape="false" class="input-xlarge number" min="0"/> <span style="color: red;">x-y*price</span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">分区2数量：</label>
			<div class="controls">
				<form:input path="interval2Num" htmlEscape="false" class="input-xlarge number" min="0"/> <span style="color: red;">x-y</span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">分区3价格：</label>
			<div class="controls">
				<form:input path="interval3Price" htmlEscape="false" class="input-xlarge number" min="0"/> <span style="color: red;">y-&*price</span>
			</div>
		</div>
		</div>
		<div class="control-group">
			<label class="control-label">重量：</label>
			<div class="controls">
				<form:input path="weight" readonly="true" htmlEscape="false" maxlength="50" class="input-xlarge "/><span style="color: red;">　KG</span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">标题：</label>
			<div class="controls">
				<form:input path="title" readonly="true" htmlEscape="false" maxlength="200" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">标签：</label>
			<div class="controls">
				<form:input path="tag" readonly="true" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">商品详细：</label>
			<div class="controls">
				<form:textarea path="details" readonly="true" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">上架：</label>
			<div class="controls">
					${fns:getDictLabel(shopGoods.isShelves,'yes_no','')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">限购：</label>
			<div class="controls">
				<form:input path="limits" readonly="true" htmlEscape="false" maxlength="11" class="input-xlarge " checked="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">数量：</label>
			<div class="controls">
				<form:input path="num" readonly="true" htmlEscape="false" maxlength="11" class="input-xlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>