<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>俱乐部采样包发放管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/sys/org/">合作机构列表</a></li>
		<shiro:hasPermission name="org:orgSampling:view"><li class="active"><a href="${ctx}/org/orgSampling/groupList?orgId=${orgId}">合作机构采样包管理</a></li></shiro:hasPermission>
		<shiro:hasPermission name="org:orgSampling:add"><li><a href="${ctx}/org/orgSampling/addForm?orgId=${orgId}">合作机构采样包发放</a></li></shiro:hasPermission>
	</ul>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>机构名称</th>
				<th>批次号</th>
				<th>采样包数量</th>
				<th>发放时间</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="groupVo">
			<tr>
				<td>
						${groupVo.orgName}
				</td>
				<td>
						${groupVo.batchNum}
				</td>
				<td>
						${groupVo.num}
				</td>
				<td>
					<fmt:formatDate value="${groupVo.postDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
				<shiro:hasPermission name="org:orgSampling:view">
    				<a href="${ctx}/org/orgSampling/detailList?batchNum=${groupVo.batchNum}&orgId=${groupVo.orgId}">物资明细</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="org:orgSampling:del">
					<c:if test="${groupVo.flowState == 1}">
					<a href="${ctx}/org/orgSampling/batchDelete?batchNum=${groupVo.batchNum}&orgId=${groupVo.orgId}" onclick="return confirmx('确认要删除该批采样包物资吗？', this.href)">删除本批</a>
					</c:if>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>