<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬舍管理</title>
	<meta name="decorator" content="default"/>
	<style type="text/css">
		.form-horizontal .control-label {
		    width: 110px!important;
		}
		.form-horizontal .controls {
		    margin-left: 100px;
		    margin-top: 3px;
		}
	</style>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
		function hello(){
			location.reload(true);
		}
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<%-- <li><a href="${ctx}/kennel/kennel/">犬舍列表</a></li>
		<li class="active"><a href="${ctx}/kennel/kennel/form?memberCode=${kennel.memberCode}">犬舍<shiro:hasPermission name="kennel:kennel:edit">${not empty kennel.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="kennel:kennel:edit">查看</shiro:lacksPermission></a></li> --%>
		<li>犬舍查看</li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="kennel" action="${ctx}/kennel/kennel/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group" style="float: left">
			<label class="control-label">会员编号：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.memberCode)}
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">会员姓名：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.member.name)}
			</div>
		</div>
		
		<div class="control-group" style="float: left">
			<label class="control-label">犬舍状态：</label>
			<div class="controls">
				<c:if test="${kennel.endTime > date}">
					已缴费
				</c:if>
				<c:if test="${empty kennel.endTime || kennel.endTime < date}">
					未缴费
				</c:if>
			</div>
		</div>

		<div class="control-group" style="float: left">
			<label class="control-label">犬舍编号：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.kennelCode)}
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">犬舍中文名：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.name)}
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬舍英文名：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.nameEn)}
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">FCI犬舍编号：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.fciKennelCode)}
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">FCI英文名：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.fciName)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">FCI备用英文名：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.fciNameBackup)}
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label" >犬舍地址：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.fciKennelAddress)}
			</div>
		</div>
		<div class="control-group"  style="float: left">
			<label class="control-label">犬舍类型：</label>
			<div class="controls">
				${fns:getDictLabel(kennel.type, 'kennel_type', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">开始时间：</label>
			<div class="controls">
				<fmt:formatDate value="${kennel.createDate}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">结束时间：</label>
			<div class="controls">
				<fmt:formatDate value="${kennel.endTime}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">犬舍审核：</label>
			<div class="controls">
				${fns:getDictLabel(kennel.reviewState, 'review_state', '')}
			</div>
		</div>		
		<div class="control-group">
			<label class="control-label">未通过原因：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.reviewRemark)}
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">FCI犬舍审核：</label>
			<div class="controls">
				${fns:getDictLabel(kennel.fciReviewState, 'fci_review_state', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">FCI未通过原因：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.fciReviewRemark)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">操作记录：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.operator)}
			</div>
		</div> 
		${fns:escapeHtml(sucess)}
		<div style="clear:both;"/>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
			<input id="btnRefresh" class="btn" type="button" value="刷新" onclick="hello()"/>
		</div>
	</form:form>
</body>
</html>