<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>结业证书管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handler/trainDiploma/addForm?id=${handlerDiploma.id}">训犬师结业证书添加</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="handlerDiploma" action="${ctx}/handler/trainDiploma/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>	
		<form:hidden path="handlerType" value="1"/>	
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-xlarge "/>
				 <span class="input-group-btn">
                <button class="btn btn-default" type="button" id="memberCodeBtn" onclick="searchUser()">查</button>
                <font id="paymentState" ></font>
                </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="64" class="input-xlarge " />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">开始时间：</label>
			<div class="controls">
				<input name="startDate" type="text"  maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${handlerDiploma.startDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">结束时间：</label>
			<div class="controls">
				<input name="endDate" type="text" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${handlerDiploma.endDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">培训教师：</label>
			<div class="controls">
				<form:input path="teacher" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">培训学校：</label>
			<div class="controls">
				<form:select id="schoolId" path="schoolId" class="input-xlarge required" >
					<form:option value="" label=""/>
	             	<form:options items="${findList}" itemLabel="schoolNameCn" itemValue="id" htmlEscape="false"/>
	   		  </form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证书级别：</label>
			<div class="controls">
			<form:select path="certificateLevel" class="input-medium required">
				<form:options items="${fns:getDictList('train_diploma_level')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
			</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证书编号：</label>
			<div class="controls">
				<form:input path="certificateCode"  htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">签发日期：</label>
			<div class="controls">
				<input name="issueDate" type="text" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${handlerDiploma.issueDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">芯片号：</label>
			<div class="controls">
				<form:input path="identificationFlag"  htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="handler:trainDiploma:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
			<script>
    //打开查询用户的弹窗
    function searchUser(){
    	var memberCode=$("#memberCode").val();
    	if(memberCode!=''){
	    	$.ajax({
	    		 type:"POST",
	             url:"${ctx}/sys/user/member/getByMemberCode",
	             data : {'memberCode':memberCode},
	             dataType: 'json',
	             async: false, 
	             success: function(json){
	            	 $("#name").val(json.name);
	             }
	    	});
    	}
    }
</script>
</body>
</html>