<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>活动录入</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
	$(document).ready(function() {
		//回显裁判信息
		var referee = '${fns:escapeHtml(handlerShow.referee)}';
		var refereeArray = referee.split(",");
		$.each(refereeArray, function(i,val) {
			$("#referee").find("option[value='"+val+"']").attr("selected",true);
	    });
		$("#referee").trigger("change");	
	});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handler/handlerShow/view?id=${fns:escapeHtml(handlerShow.id)}">活动查看</a></li>
	</ul>
	<form:form id="inputForm" modelAttribute="handlerShow"  class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		
		<div class="control-group">
			<label class="control-label">活动编号：</label>
			<div class="controls">
				${fns:escapeHtml(handlerShow.showCode)}
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">活动名称：</label>
			<div class="controls">
				${fns:escapeHtml(handlerShow.showName)}
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">活动类别：</label>
			<div class="controls">
				<form:select path="showType" disabled="true">
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('handler_show_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">级别：</label>
			<c:if test="${handlerShow.showType eq '10'}"> 
				<div class="controls">
					<form:checkboxes path="levels" items="${fns:getDictList('handler_test_level_examiner')}" itemLabel="label" itemValue="value" htmlEscape="false" disabled="true"/>
				</div>
			</c:if>
			<c:if test="${handlerShow.showType eq '11'}"> 
				<div class="controls">
					<form:checkboxes path="levels" items="${fns:getDictList('groomer_examiner_course_level')}" itemLabel="label" itemValue="value" htmlEscape="false" disabled="true"/>
				</div>
			</c:if>

			<c:if test="${handlerShow.showType eq '12' || handlerShow.showType eq '13'}">
				<div class="controls">
					<form:checkboxes path="levels" items="${fns:getDictList('handler_test_level')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required" disabled="true"/>
				</div>
			</c:if>

			<c:if test="${handlerShow.showType ne '10' && handlerShow.showType ne '11' && handlerShow.showType ne '12' && handlerShow.showType ne '13'}">
	           	 <div class="controls">
	                <form:radiobuttons path="testLevel" items="${fns:getDictList('handler_test_level')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required" disabled="true"/>
	            </div>
			</c:if>

		</div>
		
		<c:if test="${handlerShow.showType eq '10' ||handlerShow.showType eq '11'}">
			<div class="control-group">
				<label class="control-label">人数限制：</label>
				<div class="controls">
					${fns:escapeHtml(handlerShow.maxNumber)}
				</div>
			</div>
		</c:if>
		<div class="control-group">
			<label class="control-label">开始日期：</label>
			<div class="controls">
				<fmt:formatDate value="${handlerShow.startTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">结束日期：</label>
			<div class="controls">
				<fmt:formatDate value="${handlerShow.endTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">报名截止时间：</label>
			<div class="controls">
				<fmt:formatDate value="${handlerShow.registerEndTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div>
		
		 <div class="control-group">
              <label class="control-label">官网是否展示：</label>
                <div class="controls">
               		<c:if test="${handlerShow.isShowWebsite=='0'}">展示</c:if>
					<c:if test="${handlerShow.isShowWebsite=='1'}">不展示</c:if>
                </div>
            </div>
            
		<div class="control-group" style="width:80%">
           <label class="control-label">活动图片：</label>
           <div class="controls">
	           <sys:singleMultiImgUpload moduleId="showPhoto" module="member" imgId="${handlerShow.showPhoto}" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*1024*1"/>
	           <form:input path="showPhoto" id="showPhoto" htmlEscape="false" maxlength="255" class="input-xlarge" type="hidden"/>
           </div>
        </div>
		
		<div class="control-group" style="width:80%">      
            <label class="control-label">网站缩略图：</label>
            <div class="controls">         
	            <sys:singleMultiImgUpload state="1" moduleId="websitePhoto" module="member" imgId="${handlerShow.websitePhoto}" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*1024*1"/>
	            <form:input path="websitePhoto" id="websitePhoto" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
            </div>
        </div>
		 <!-- 文件上传成功的回调方法 -->
        <script type="text/javascript">
            function uploadSuccessCallback(moduleId,file,response){
                $("#"+moduleId).val(response.id);
            }
        </script>
		
		<div class="control-group">
			<label class="control-label">缩略图地址：</label>
			<div class="controls">
				${fns:escapeHtml(handlerShow.photoRoute)}
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">活动地点：</label>
			<div class="controls">
				${fns:escapeHtml(handlerShow.showAddress)}
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">裁判：</label>
			<div class="controls">
                <form:select id="referee" path="referee" class="input-xxlarge required" multiple="true">
                	<form:options items="${showRefereeList}" itemLabel="refereeNameCn" itemValue="id" htmlEscape="false"/>
                </form:select>
                <ul>
                   <li><font color="#FF0000">注：可以多选裁判！ </font></li>
                </ul>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">报名费：</label>
			<div class="controls">
				${fns:escapeHtml(handlerShow.fee)}
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				${fns:escapeHtml(handlerShow.remarks)}
			</div>
		</div>
		
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>