<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>赛事审查员管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
	<link rel="stylesheet" type="text/css" href="${ctxStatic }/wangEditor/css/wangEditor.min.css">
	<link href="${ctxStatic}/layui/css/layui.css" rel="stylesheet" />
	<script src="${ctxStatic}/layui/layui.js" type="text/javascript"></script>
	<script src="${ctxStatic}/layui/lay/dest/layui.all.js" type="text/javascript"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/groomer/groomerShowReferee/">美容师审查员列表</a></li>
		<li class="active"><a href="${ctx}/groomer/groomerShowReferee/form?id=${groomerShowReferee.id}">美容师审查员<shiro:hasPermission name="referee:showReferee:edit">${not empty showReferee.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="referee:showReferee:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="groomerShowReferee" action="${ctx}/groomer/groomerShowReferee/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">审查员中文名：</label>
			<div class="controls">
				<form:input path="refereeNameCn" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员英文名：</label>
			<div class="controls">
				<form:input path="refereeNameEn" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员性别：</label>
			<div class="controls">
				<form:select path="refereeSex" class="input-small required">
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('sex')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员国籍：</label>
			<div class="controls">
				<form:input path="refereeCitizenship" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员图片：</label>
			<div class="controls">
				<div style="float:left;width:50%;">
					<div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;">
						<c:if test="${empty groomerShowReferee.refereePicture }">
							<center><img id="previewCatImg" alt="" src="" style="padding:10px;height:130px;"/></center>
						</c:if>
						<c:if test="${not empty groomerShowReferee.refereePicture }">
							<center><img id="previewCatImg" alt="" src="${ctx}/sys/file/image/${groomerShowReferee.refereePicture}" style="padding:10px;height:130px;"/></center>
						</c:if>
						<div style="position:relative;color: #cccccc;font-size: 18px;"><center>图片预览</center></div>
					</div>
				</div>
				<div style="float:right;width:50%;">
					<div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;position:relative;">
						<div style="height:40px;left:36%; position:absolute;  top:38%;" >
							<input id="judgePictureBtn" type="file" name="file" lay-type="image" lay-title="请上传审查员图" class="layui-upload-file">
						</div>
						<form:input path="refereePicture" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
					</div>
				</div>
				<script type="text/javascript">
					layui.upload({
						url: '${ctx}/sys/file/uploadGroomerRefereePicture'
						,elem: '#judgePictureBtn' //指定原始元素，默认直接查找class="layui-upload-file"
						,method: 'POST' //上传接口的http类型
						,success: function(res){
							$("#refereePicture").val(res.id);
							$("#previewCatImg").attr("src",res.url);
						}
					});
				</script>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员签名照片：</label>
			<div class="controls">
				<div style="float:left;width:50%;">
					<div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;">
						<c:if test="${empty groomerShowReferee.refereeSignaturePhoto }">
							<center><img id="previewSignatureImg" alt="" src="" style="padding:10px;height:130px;"/></center>
						</c:if>
						<c:if test="${not empty groomerShowReferee.refereeSignaturePhoto }">
							<center><img id="previewSignatureImg" alt="" src="${ctx}/sys/file/image/${groomerShowReferee.refereeSignaturePhoto}" style="padding:10px;height:130px;"/></center>
						</c:if>
						<div style="position:relative;color: #cccccc;font-size: 18px;"><center>图片预览</center></div>
					</div>
				</div>
				<div style="float:right;width:50%;">
					<div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;position:relative;">
						<div style="height:40px;left:36%; position:absolute;  top:38%;" >
							<input id="refereeSignaturePhotoBtn" type="file" name="file" lay-type="image" lay-title="请上传审查员签名图" class="layui-upload-file">
						</div>
						<form:input path="refereeSignaturePhoto" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
					</div>
				</div>
				<script type="text/javascript">
					layui.upload({
						url: '${ctx}/sys/file/uploadGroomerRefereeSignaturePhoto'
						,elem: '#refereeSignaturePhotoBtn' //指定原始元素，默认直接查找class="layui-upload-file"
						,method: 'POST' //上传接口的http类型
						,success: function(res){
							$("#refereeSignaturePhoto").val(res.id);
							$("#previewSignatureImg").attr("src",res.url);
						}
					});
				</script>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">审查员介绍：</label>
			<div class="controls">
				<form:input path="refereeIntroduce" htmlEscape="false" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员类型：</label>
			<div class="controls">
				<form:select path="refereeType" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('show_referee_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员头衔：</label>
			<div class="controls">
				<form:input path="refereeTitle" htmlEscape="false" maxlength="200" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">link_order：</label>
			<div class="controls">
				<form:input path="refereeLinkOrder" htmlEscape="false" maxlength="11" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="groomer:groomerShowReferee:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>