<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>活动管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			// 选择下拉列表
			var $select = $('#showCategoryClass');

			// 遍历所有的 <option> 元素
			$select.find('option').each(function() {
				// 检查 value 是否等于 5 为FCI增发类型，不展示
				if ($(this).val() === '5') {
					// 从下拉列表中移除该 <option>
					$(this).remove();
				}
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }

		function openPage(){
			location.href="${ctx}/groomer/groomerShow/form";
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/groomer/groomerShow/">活动管理</a></li>
		<shiro:hasPermission name="groomer:groomerRegister:view"><li><a href="${ctx}/groomer/groomerRegister">报名信息管理</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="groomerShow" action="${ctx}/groomer/groomerShow/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>活动名称：</label>
				<form:input path="showName" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>活动分类：</label>
				<form:select path="showCategory" id="showCategoryClass" class="input-xlarge required">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('groomer_show_category')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>活动类型：</label>
				<form:select path="showType" class="input-xlarge required">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('groomer_show_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>赛事编号：</label>
				<form:input path="showCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>活动地点：</label>
				<form:input path="showAddress" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="btns"><shiro:hasPermission name="groomer:groomerShow:add"><button  type="button" class="btn btn-primary" onclick="openPage();">活动录入</button></shiro:hasPermission></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>赛事编号</th>
				<th>活动类型</th>
				<th>活动分类</th>
				<th>活动名称</th>
				<th>活动地点</th>
				<th>开始日期</th>
				<th>结束日期</th>
				<th>截止时间</th>
				<th>报名费</th>
				<th>报名状态</th>
				<th>操作</th>
				<shiro:hasPermission name="groomer:groomerShow:register"><th>报名</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="groomerShow">
			<tr>
				<td>
					${fns:escapeHtml(groomerShow.showCode)}
				</td>
				<td>
					${fns:getDictLabel(groomerShow.showType, 'groomer_show_type', '')}
				</td>
				<td>
					${fns:getDictLabel(groomerShow.showCategory, 'groomer_show_category', '')}
				</td>
				<td>
					${fns:escapeHtml(groomerShow.showName)}
				</td>
				<td>
					${fns:escapeHtml(groomerShow.showAddress)}
				</td>
				<td>
					<fmt:formatDate value="${groomerShow.startTime}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${groomerShow.endTime}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${groomerShow.registerEndTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${fns:escapeHtml(groomerShow.fee)}
				</td>
				<td>
					<c:choose>
						<c:when test="${groomerShow.registerEndTime > date}">
							<font color="green">开放</font>
						</c:when>
						<c:otherwise>
							<font color="red">关闭</font>
						</c:otherwise>
					</c:choose>
				</td>
				<td>
				<shiro:hasPermission name="groomer:groomerShow:view">
					<a href="${ctx}/groomer/groomerShow/view?id=${fns:escapeHtml(groomerShow.id)}">查看</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="groomer:groomerShow:edit">
    				<a href="${ctx}/groomer/groomerShow/form?id=${fns:escapeHtml(groomerShow.id)}">编辑</a>
    			</shiro:hasPermission>
    			<shiro:hasPermission name="groomer:groomerShow:delete">
					<a href="${ctx}/groomer/groomerShow/delete?id=${fns:escapeHtml(groomerShow.id)}" onclick="return confirmx('确认要删除该美容师活动吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
				<td>
					<shiro:hasPermission name="groomer:groomerShow:register">
						<c:choose>
							<c:when test="${groomerShow.registerEndTime > date}">
								<c:if test="${groomerShow.showType=='team'}">
									<a href="${ctx}/groomer/groomerShow/registerTTForm?id=${fns:escapeHtml(groomerShow.id)}">报名</a>
								</c:if>
								<c:if test="${groomerShow.showType!='team'}">
									<a href="${ctx}/groomer/groomerShow/registerForm?id=${fns:escapeHtml(groomerShow.id)}">报名</a>
								</c:if>
							</c:when>
							<c:otherwise>
								<shiro:hasPermission name="groomer:groomerShow:registerExpired">
									<c:if test="${groomerShow.showType=='team'}">
										<a href="${ctx}/groomer/groomerShow/registerTTForm?id=${fns:escapeHtml(groomerShow.id)}">报名</a>
									</c:if>
									<c:if test="${groomerShow.showType!='team'}">
										<a href="${ctx}/groomer/groomerShow/registerForm?id=${fns:escapeHtml(groomerShow.id)}">报名</a>
									</c:if>
								</shiro:hasPermission>
							</c:otherwise>
						</c:choose>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>