<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>业务分类管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
            //初始化界面
            let isView = '${isView}';
            if (isView == 1) {
                $('#btnSubmit').hide();
                $('#inputForm input').attr('disabled','true');
                $('#inputForm select').attr('disabled','true');
                $('#inputForm textarea').attr('disabled','true');
                $('#inputForm input').unbind();
                $('#btnCancel').removeAttr('disabled');
            }
            //初始化表单
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/goods/sysBusinessCate/">业务分类列表</a></li>
		<li class="active">
			<c:choose>
				<c:when test="${not empty sysBusinessCate.id and isView == 1}">
					<a href="${ctx}/goods/sysBusinessCate/viewForm?id=${sysBusinessCate.id}">业务分类查看</a>
				</c:when>
				<c:when test="${not empty sysBusinessCate.id and isView == 0}">
					<a href="${ctx}/goods/sysBusinessCate/editForm?id=${sysBusinessCate.id}">业务分类编辑</a>
				</c:when>
				<c:otherwise>
					<a href="${ctx}/goods/sysBusinessCate/editForm">业务分类添加</a>
				</c:otherwise>
			</c:choose>
		</li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="sysBusinessCate" action="${ctx}/goods/sysBusinessCate/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">分类名称：</label>
			<div class="controls">
				<form:input path="cateName" htmlEscape="false" maxlength="32" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">分类编号：</label>
			<div class="controls">
				<form:input path="cateCode" htmlEscape="false" maxlength="32" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">排序：</label>
			<div class="controls">
				<form:input path="sort" htmlEscape="false" class="input-xlarge digits"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="goods:sysBusinessCate:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>