<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>新生犬登记管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function openEditPage(id,birthCode,dogOwenr,createDate,hospitalCode){
			parent.layer.open({
		        type: 2,
		        title: ['新生犬登记审核', 'font-size:18px;text-align: center;'],
		        shadeClose: false,
		        shade: [0.8, '#393D49'],
		        maxmin: false, //开启最大化最小化按钮
		        area: ['560px', '480px'],
		        content: ctx+"/newdogchip/dogChip/review?id="+id,
		        end: function(){
		            if(parent.isYes){
		                var mainF = parent.$("#mainFrame");
		                mainF.contents().find("#searchForm").submit();
		            };
		        }
		    });
		};
		function openViewPage(id,birthCode,dogOwenr,createDate,hospitalCode){
            parent.layer.open({
                type: 2,
                title: ['新生犬登记查看', 'font-size:18px;text-align: center;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['560px', '480px'],
                content: ctx+"/newdogchip/dogChip/view?id="+id,
                end: function(){
                    if(parent.isYes){
                        var mainF = parent.$("#mainFrame");
                        mainF.contents().find("#searchForm").submit();
                    };
                }
            });
        };
		function changeProcessState(id){
			var msg=confirm("确认要处理该新生犬登记吗？");
		    if(msg==true){
		    	$.ajax({
	                type: "POST",
	                url:"${ctx}/newdogchip/dogChip/process?id="+id,
	                dataType:"json",
	                async: false,
	                error: function(request, textStatus, errorThrown) {
	                	if(request.status=='403'&&errorThrown=='Forbidden'){
	                		alert("服务器拒绝您的访问，请查看是否存在此功能操作权限！");
	                	} else {
	                		alert("错误代码："+request.status+"，错误描述："+errorThrown);
	                	}
	                },
	                success: function(data) {
	                    if(data.rc==0){
	                        alert("处理成功");
	                        var mainF = parent.$("#mainFrame");
	                        mainF.contents().find("#searchForm").submit();
	                    }else {
	                        alert("错误代码："+data.rc+"错误信息："+data.msg);
	                        parent.isYes = false;
	                    }
	                }
	            });
		    } else {
		    	return;
		    }
		}


		function changeOrg(id){
 			parent.layer.open({
				type: 2,
				title: ['办理类型', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['800px', '600px'],
				content: ctx+"/newdogchip/dogChip/changeOrg?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		}
	</script>
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
    <script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/newdogchip/dogChip/">新生犬登记列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogChip" action="${ctx}/newdogchip/dogChip/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>出生纸编号：</label>
				<form:input path="birthCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>芯片号：</label>
				<form:input path="identificationFlag" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>宠爱护照号：</label>
				<form:input path="dogBirthCertificate.cabPassportLike" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员号/姓名：</label>
				<form:input path="dogBirthCertificate.dogOwenr" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>合作医院：</label>
			    <form:input path="sysOrg.name" htmlEscape="false" maxlength="64" class="input-medium"/>
            </li>
            <li><label>合作机构类型：</label>
                <form:select path="sysOrg.orgType" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('sys_org_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
            <li><label>审核状态：</label>
                <form:select path="reviewState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
            <li><label>付款状态：</label>
                <form:select path="paymentState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
            <li><label>采血状态：</label>
                <form:select path="bloodSaveFlag" class="input-medium">
                    <form:option value="" label="全部"/>
					<form:option value="0" label="未采血"/>
					<form:option value="1" label="已采血"/>
                </form:select>
            </li>
            
            <li><label>办理类型：</label>
                <form:select path="haddleWay" class="input-medium">
                    <form:option value="" label="全部"/>
					<form:option value="0" label="自主办理"/>
					<form:option value="1" label="合作机构"/>
                </form:select>
            </li>
            
            
            <li><label>申请时间：</label>
                <input name="createDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${dogChip.createDate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>-
                    <input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${dogChip.endDate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
            </li>
            <li><label>芯片注入时间：</label>
                <input name="chipInjectDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${dogChip.chipInjectDate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>-
                    <input name="endInjectDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${dogChip.endInjectDate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
            </li>
            <li><label>撤销时间：</label>
                <input name="canceledDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${dogChip.canceledDate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>-
                    <input name="canceledEndDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${dogChip.canceledEndDate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
            </li>
            <li><label>撤销状态：</label>
                <form:select path="isCanceled" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('canceled_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
			<li><label>处理状态：</label>
				<form:select path="processState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('proccess_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>处理时间：</label>
				<input name="processStartDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${dogChip.processStartDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>-
				<input name="processEndDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${dogChip.processEndDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
            <li><label>处理人：</label>
                <form:select path="processUserId" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:option value="105412" label="张永祺"/>
                </form:select>
            </li>
            <li><label>打印状态：</label>
                <form:select path="printState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:option value="2" label="未打印"/>
                    <form:option value="02" label="已打印"/>
                </form:select>
            </li>
			<li><label>鼻纹已录入：</label>
				<form:select path="noseState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>芯片已录入：</label>
				<form:select path="identificationFlagState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>出生纸编号</th>
				<th>犬主</th>
				<th>申请时间</th>
				<th>办理类型</th>
				<th>申请医院</th>
				<th>血统证书号</th>
				<th>芯片号</th>
				<th>宠爱护照号</th>
				<th>流水号</th>
				<th>付款状态</th>
				<th>审核状态</th>
				<th>采血状态</th>
				<th>鼻纹状态</th>
				<th>办理方式</th>
				<th>处理状态</th>
				<th>撤销状态</th>
				<th>撤销时间</th>
				<th>业务状态</th>
				<th>证书类型</th>
				<th>打印</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogChip">
			<tr>
				<td>
					${fns:desensitize(dogChip.birthCode,4) }
				</td>
				<c:if test="${not empty dogChip.dogBirthCertificate.tempMemberCode}">
					<td title="${dogChip.dogBirthCertificate.tempMemberCode}">
							${fns:escapeHtml(dogChip.dogBirthCertificate.tempUserName) }
					</td>
				</c:if>
				<c:if test="${empty dogChip.dogBirthCertificate.tempMemberCode}">
					<td title="${dogChip.dogBirthCertificate.memberCode}">
							${fns:escapeHtml(dogChip.dogBirthCertificate.dogOwenr) }
					</td>
				</c:if>
				<td>
                    <fmt:formatDate value="${dogChip.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
                </td>
                
                <td>
                	<c:choose>
                		<c:when test="${dogChip.processState eq '0'}">
                			<c:if test="${empty dogChip.haddleWay || '1' eq dogChip.haddleWay }">
                				<a  onclick="changeOrg('${fns:escapeHtml(dogChip.id)}')">机构办理</a>
                			</c:if>
		                	<c:if test="${ '0' eq  dogChip.haddleWay }">
		                		<a  onclick="changeOrg('${fns:escapeHtml(dogChip.id)}')">自主办理</a>
		                	</c:if>
                		</c:when>
                		 <c:otherwise>
                		 	<c:if test="${empty dogChip.haddleWay || '1' eq dogChip.haddleWay }">
                				机构办理
                			</c:if>
		                	<c:if test="${ '0' eq  dogChip.haddleWay }">
		                		自主办理
		                	</c:if>
                		 </c:otherwise>
                	</c:choose>
                	
                </td>
                
                <td>
                    ${fns:escapeHtml(dogChip.sysOrg.name) }
                </td>
                <td>
					<c:if test="${dogChip.reviewState!=3}">
						${fns:desensitize(dogChip.dogBirthCertificate.pedigreeCertified,1) }
					</c:if>
                </td>
                <td>
                    ${fns:desensitize(dogChip.dogBirthCertificate.identificationFlag,2) }
                </td>
                <td>
                    ${fns:desensitize(dogChip.dogBirthCertificate.cabPassport,3) }
                </td>
				<td>
					${fns:escapeHtml(dogChip.runningNumber) }
				</td>
				<td>
				    <c:if test="${dogChip.paymentState==1}"><font color="red">${fns:getDictLabel(dogChip.paymentState, 'user_payment_state', '')}</font></c:if>
				    <c:if test="${dogChip.paymentState==2}"><font color="green">${fns:getDictLabel(dogChip.paymentState, 'user_payment_state', '')}</font></c:if>
				</td>
				<td title="${fns:escapeHtml(dogChip.reviewRemarks) }">
					<c:choose>
						<c:when test="${dogChip.reviewState==3 || dogChip.businessRefundState}">
							${fns:getDictLabel(dogChip.reviewState, 'review_state', '')}
						</c:when>
						<c:otherwise>
							<a onclick="openEditPage('${dogChip.id}','${dogChip.birthCode}','${dogChip.dogBirthCertificate.dogOwenr}','${dogChip.createDate}','${dogChip.hospitalCode}')"
							   href="#">
								<c:if test="${dogChip.reviewState==0}">
									<font color="red">
								</c:if>
										${fns:getDictLabel(dogChip.reviewState, 'review_state', '')}
								<c:if test="${dogChip.reviewState==0}">
									</font>
								</c:if>
							</a>
						</c:otherwise>
					</c:choose>
                </td>
				<td>
					<c:if test="${dogChip.bloodSaveFlag=='0'}">
						未采血
					</c:if>
					<c:if test="${dogChip.bloodSaveFlag=='1'}">
						已采血
					</c:if>
				</td>
				<td>
					<c:if test="${empty dogChip.noseId }">
						未采集
					</c:if>

					<c:if test="${not empty dogChip.noseId }">
						已采集
					</c:if>
				</td>
				<td>
					<c:if test="${dogChip.isAll=='1'}">
						整窝办理
					</c:if>
					<c:if test="${dogChip.isAll=='0'}">
						单只办理
					</c:if>
				</td>
                <td>
                <c:if test="${dogChip.processState==0}">
					<c:choose>
						<c:when test="${'1' eq dogChip.isCanceled ||dogChip.businessRefundState}">
							${fns:getDictLabel(dogChip.processState, 'proccess_state', '')}
						</c:when>
						<c:otherwise>
							<a onclick="changeProcessState('${dogChip.id}')">${fns:getDictLabel(dogChip.processState, 'proccess_state', '')}</a>
						</c:otherwise>
					</c:choose>
				</c:if>
                <c:if test="${dogChip.processState==1}">${fns:getDictLabel(dogChip.processState, 'proccess_state', '')}</c:if>
                </td>
                <td>
                    <c:if test="${'1' eq dogChip.isCanceled}">已撤销</c:if>
                    <c:if test="${dogChip.isCanceled!='1'}">
                    <c:if test="${'1' eq dogChip.reviewState
                    	&& (empty dogChip.dogBirthCertificate.identificationFlag||empty dogChip.dogChipChangeId)
                    	&& !dogChip.businessRefundState}">
                    <a href="${ctx}/newdogchip/dogChip/canceled?id=${dogChip.id}" onclick="return confirmx('确认要撤销该新生犬登记吗？', this.href)"></c:if>撤销<c:if test="${'1' eq dogChip.reviewState && (empty dogChip.dogBirthCertificate.identificationFlag||empty dogChip.dogChipChangeId)}"></a></c:if>
                    </c:if>
                </td>
                <td>
                    <fmt:formatDate value="${dogChip.delTime}" pattern="yyyy-MM-dd"/>
                </td>
				<td>
					${dogChip.businessState}
				</td>
				<td>
					<c:if test="${dogChip.ecertFlag == '0' }">
						纸质版
					</c:if>
					<c:if test="${dogChip.ecertFlag == '1' }">
						电子版
					</c:if>
				</td>
				<td>

				<c:if test="${ dogChip.ecertFlag == '0' }">
					<c:if test="${dogChip.processState=='1'}">
					<shiro:hasPermission name="newdogchip:dogChip:print">
					    <c:if test="${dogChip.printState=='2'}">
					    	<a href="###" onclick="print('${ctx}/newdogchip/dogChip/print?id=${dogChip.id}');">打印</a>
					    </c:if>
					</shiro:hasPermission>
					<shiro:hasPermission name="newdogchip:dogChip:resetPrint">
					    <c:if test="${dogChip.printState=='02'}">
					    	<a href="###" onclick="resetPrint('${ctx}/newdogchip/dogChip/resetPrint?id=${dogChip.id}');">重置打印</a>
					    </c:if>
					</shiro:hasPermission>
					</c:if>
				</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>