<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>DNA双亲比对管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function auditForm(id){
			parent.layer.open({
				type: 2,
				title: ['DNA双亲比对审核', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['800px', '600px'],
				content: ctx+"/dogdnaparentscompare/dogDnaParentsCompare/auditForm?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		}
		
		function openReviewPage(id){
            parent.layer.open({
                type: 2,
                title: ['父母犬主审核', 'font-size:18px;text-align: center;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['800px', '700px'],
                content: ctx+"/dogdnaparentscompare/dogDnaParentsCompare/auditFMdogForm?id="+id,
                end: function(){
                    if(parent.isYes){
                        var mainF = parent.$("#mainFrame");
                        mainF.contents().find("#searchForm").submit();
                    };
                }
            }); 
        };
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dogdnaparentscompare/dogDnaParentsCompare/">DNA双亲比对列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogDnaParentsCompare" action="${ctx}/dogdnaparentscompare/dogDnaParentsCompare/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>出生纸/证书号：</label>
				<form:input path="birthCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>父/母犬证书号：</label>
				<form:input path="parentDogPedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员号/姓名：</label>
			<form:input path="paymentMemberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>订单状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('dna_parents_compare_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>办理方式：</label>
				<form:select path="applySource" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('dna_parents_compare_apply_source')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>金质证书状态：</label>
				<form:select path="goldCertifiedState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('gold_certified_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>撤销状态：</label>
				<form:select path="isCanceled" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="0" label="未撤销"/>
					<form:option value="1" label="已撤销"/>
					<%--<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>--%>
				</form:select>
			</li>
			<li><label>申请日期：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogDnaParentsCompare.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogDnaParentsCompare.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>出生纸编号</th>
				<th>血统证书编号</th>
				<th>犬主</th>
				<th>父血统证书号</th>
				<th>母血统证书号</th>
				<th>申请日期</th>
				<th>办理方式</th>
				<th>金质证书状态</th>
				<th>订单状态</th>
				<th>父犬主审核</th>
				<th>父犬主审核人</th>
				<th>母犬主审核</th>
				<th>母犬主审核人</th>
				<th>审核状态</th>
				<th>撤销状态</th>
				<shiro:hasPermission name="dogdnaparentscompare:dogDnaParentsCompare:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogDnaParentsCompare">
			<tr>
				<td>
					${dogDnaParentsCompare.birthCode}
				</td>
				<td>
					${dogDnaParentsCompare.pedigreeCertified}
				</td>
				<td>
					${dogDnaParentsCompare.name}
				</td>
				<td>
					${dogDnaParentsCompare.fdogPedigreeCertified}
				</td>
				<td>
					${dogDnaParentsCompare.mdogPedigreeCertified}
				</td>
				<td>
					<fmt:formatDate value="${dogDnaParentsCompare.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
						${fns:getDictLabel(dogDnaParentsCompare.applySource, 'dna_parents_compare_apply_source', '')}
				</td>
				<td>
						${fns:getDictLabel(dogDnaParentsCompare.goldCertifiedState, 'gold_certified_state', '')}
				</td>
				<td style="color:${dogDnaParentsCompare.paymentState=='2'?'#090':'#F00'}">
						${fns:getDictLabel(dogDnaParentsCompare.paymentState, 'user_payment_state', '')}
				</td>
				<td>
					<c:choose>
					  <c:when test="${dogDnaParentsCompare.paymentState==2 && dogDnaParentsCompare.isCanceled!='1'}">
	                    <a onclick="openReviewPage('${dogDnaParentsCompare.id}')">
		                       ${fns:getDictLabel(dogDnaParentsCompare.fdogReviewState, 'dog_dna_parents_compare_audit_review_state', '')}
	                    </a>
	                   </c:when>
	                   <c:otherwise>
	                     	${fns:getDictLabel(dogDnaParentsCompare.fdogReviewState, 'dog_dna_parents_compare_audit_review_state', '')}
	                   </c:otherwise>
	                </c:choose>
					
				</td>
				<td>${dogDnaParentsCompare.fdogReviewUserName}</td>
				<td>
					<c:choose>
					  <c:when test="${dogDnaParentsCompare.paymentState==2 && dogDnaParentsCompare.isCanceled!='1'}">
	                    <a onclick="openReviewPage('${dogDnaParentsCompare.id}')">
		                       ${fns:getDictLabel(dogDnaParentsCompare.mdogReviewState, 'dog_dna_parents_compare_audit_review_state', '')}
	                    </a>
	                   </c:when>
	                   <c:otherwise>
	                     	${fns:getDictLabel(dogDnaParentsCompare.mdogReviewState, 'dog_dna_parents_compare_audit_review_state', '')}
	                   </c:otherwise>
	                </c:choose>
				</td>
				<td>${dogDnaParentsCompare.mdogReviewUserName}</td>
				<td>
					<c:if test="${dogDnaParentsCompare.paymentState==2 }">
						<c:choose>
						<c:when test="${(dogDnaParentsCompare.reviewState!=1)&& !dogDnaParentsCompare.businessRefundState}">
							<a onclick="auditForm('${dogDnaParentsCompare.id}')">
								${fns:getDictLabel(dogDnaParentsCompare.reviewState, 'dna_parents_compare_review_state', '')}
							</a>
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(dogDnaParentsCompare.reviewState, 'dna_parents_compare_review_state', '')}
						</c:otherwise>
						</c:choose>
					</c:if>
					<shiro:hasPermission name="dogdnaparentscompare:dogDnaParentsCompare:downgrade">
						<c:if test="${dogDnaParentsCompare.reviewState =='2'
							&& dogDnaParentsCompare.goldCertifiedState !='0'
							&& dogDnaParentsCompare.applySource !='0'
							&& !dogDnaParentsCompare.businessRefundState}">
							<a href="${ctx}/dogdnaparentscompare/dogDnaParentsCompare/downgrade?id=${dogDnaParentsCompare.id}"
							   onclick="return confirmx('确认要降级金质证书吗？', this.href)">降级</a>
						</c:if>
					</shiro:hasPermission>
				</td>
				<td>
					<c:if test="${dogDnaParentsCompare.isCanceled=='1'}">
						已撤销
					</c:if>
				</td>
				<td>
					<shiro:hasPermission name="dogdnaparentscompare:dogDnaParentsCompare:delete">
					<c:if test="${dogDnaParentsCompare.paymentState=='2' && dogDnaParentsCompare.isCanceled!='1' && !dogDnaParentsCompare.businessRefundState }">
						<a href="${ctx}/dogdnaparentscompare/dogDnaParentsCompare/cancel?id=${dogDnaParentsCompare.id}"
						   onclick="return confirmx('确认要撤销该DNA双亲比对吗？', this.href)">撤销</a>
					</c:if>
					</shiro:hasPermission>
					<shiro:hasPermission name="dogdnaparentscompare:dogDnaParentsCompare:delete">
						<c:if test="${!dogDnaParentsCompare.businessRefundState}">
							<a href="${ctx}/dogdnaparentscompare/dogDnaParentsCompare/delete?id=${dogDnaParentsCompare.id}"
							   onclick="return confirmx('确认要删除该DNA双亲比对吗？', this.href)">删除</a>
						</c:if>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>