<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>课件资料关联</title>
    <meta name="decorator" content="default"/>
    <script src="${ctxStatic}/bootstrap-table/bootstrap-table.min.js"></script>
    <script src="${ctxStatic}/bootstrap-table//bootstrap-table-zh-CN.min.js"></script>
    <script src="${ctxStatic}/utils/transfer.js"></script>

    <style>
        #transferContainer{
            display: flex;
            justify-content: center;
            height: 446px;
            overflow-y: auto;
        }
        #transferUnselectTable thead{
            display: none!important;
        }
        #transferSelectTable thead{
            display: none!important;
        }
        .loading-text{
            display: none;
        }
        iframe body{
            min-height: auto!important;
        }
        .table{
            margin-bottom: 0;
        }
        .fixed-table-border{
            display: none!important;
        }
        .form-actions{
            margin-top: 0!important;
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            box-sizing: border-box;
        }
    </style>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#transferContainer').transfer({
                titles: ['待选列表', '已选列表'],
                search: true,
                uniqueId: "id", //唯一id
                url: "${ctx}/appreciation/appreciationCourseware/restList?id=${appreciationCourses.id}",
                unselectColumns: [{
                    field: 'flag',
                    checkbox: true,
                    formatter: function(value, row, index) {
                        if(row.states == '0'){
                            return { disabled : true}
                        }
                    }
                }, {
                    field: 'coursewareName',
                    title: '资料名称'
                }]
            });
        });

        function closeLayer() {
            parent.isYes = false;
            parent.layer.closeAll();
        }

        function save() {
            let coursewareIds = $('#transferContainer').transfer('getData', 'selectData', 'id');
            let data = {}
            data['courseId'] = '${appreciationCourses.id}'
            data['coursewareIds'] = coursewareIds.toString()
            $.ajax({
                type: "POST",
                url: "${ctx}/appreciation/appreciationCourses/coursesCoursewareRel",
                dataType: "json",
                // contentType: 'application/json;charset=UTF-8',
                data: data,
                async: false,
                error: function (request, textStatus, errorThrown) {
                    alert("系统错误，请联系管理员！");
                },
                success: function (data) {
                    if (data.rc == 0) {
                        alert("关联成功");
                        parent.isYes = true;
                        parent.layer.closeAll();
                    } else {
                        alert(data.msg);
                        parent.isYes = false;
                        parent.layer.closeAll();
                    }
                }
            });
        }
    </script>
</head>
<body style="height: auto">
<form:form id="inputForm" modelAttribute="appreciationCourses" method="post" class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div id="transferContainer" class="row" ></div>
    <div class="form-actions">
        <shiro:hasPermission name="appreciation:appreciationCourses:rel">
            <input id="btnSubmit" class="btn btn-primary" type="button" value="提交" onclick="save()"/>&nbsp;
        </shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="关闭" onclick="closeLayer()"/>
    </div>
</form:form>
</body>
</html>