package com.cku.subsystem.dog;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.cku.oa.dog.entity.DogBloodSave;
import com.cku.oa.dog.service.DogBloodSaveService;
import com.cku.oa.sys.service.LoginServerService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * DNA血样留存Controller
 * @author lgl
 * @version 2016-11-24
 */
@Controller
	@RequestMapping(value = "/subSystem/dogBloodSave")
public class SubDogBloodSaveController extends BaseController {

	@Autowired
	private DogBloodSaveService dogBloodSaveService;

	@Autowired
	private LoginServerService loginServerService;
	
	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}
	



	@ModelAttribute
	public DogBloodSave get(@RequestParam(required=false) String id) {
		DogBloodSave entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogBloodSaveService.get(id);
		}
		if (entity == null){
			entity = new DogBloodSave();
		}
		return entity;
	}

	@RequestMapping(value = {"list", ""})
	public String list(DogBloodSave dogBloodSave, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogBloodSave> page = dogBloodSaveService.findPage(new Page<DogBloodSave>(request, response), dogBloodSave);
		model.addAttribute("page", page);
		return "subSystem/"+getUrlByUserType()+"/dog/dogbloodsave/dogBloodSaveList";
	}

	@RequestMapping(value = "form")
	public String form(DogBloodSave dogBloodSave, Model model) {
		model.addAttribute("dogBloodSave", dogBloodSave);
		return "subSystem/"+getUrlByUserType()+"/dog/dogbloodsave/dogBloodSaveForm";
	}


}