/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v2.groomer.web;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.groomer.service.RestGroomerDiplomaService;
import com.cku.restful.v1.groomer.service.RestGroomerQualificationCertifiCateService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 犬只信息管理Controller
 * 
 * @author zhuoHeng
 * @version 2016-08-03
 */
@Controller
@RequestMapping(value = "/cku/v2/groomer")
public class CkuGroomerControllerV2 extends BaseRestController {

	@Autowired
	private RestGroomerDiplomaService restGroomerDiplomaService;
	@Autowired
	public RestGroomerQualificationCertifiCateService restGroomerQualificationCertifiCateService;

	/**
	 * 
	 * @description: CKU官网美容结业证书查询
	 * @author: laiguanglong
	 * @date: 2016年9月27日 下午8:11:40
	 */
	@RequestMapping(value = "/groomerDiploma", method = RequestMethod.GET)
	@ResponseBody
	public void groomerDiploma(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restGroomerDiplomaService.getByKey(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 
	 * @description: CKU官网美容资格证书查询
	 * @author: laiguanglong
	 * @date: 2016年9月27日 下午8:11:40
	 */
	@RequestMapping(value = "/groomerQualificationCertificate", method = RequestMethod.GET)
	@ResponseBody
	public void groomerQualificationCertificate(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restGroomerQualificationCertifiCateService
				.getByKey(request);
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 
	 * @description: CKU官网美容胸花申领查询
	 * @author: xinhongwei
	 * @throws IOException 
	 * @date: 2017年2月7日 下午4:00:40
	 */
	@RequestMapping(value = "/groomerCorsageClaim", method = RequestMethod.GET)
	@ResponseBody
	public void groomerCorsageClaim(HttpServletRequest request,
			HttpServletResponse response) throws IOException{
		RESTResponse result = restGroomerQualificationCertifiCateService.getCorsageClaimList();
		ServletUtils.writeResponse(response, result);
	}

}