package com.cku.restful.v1.sys.utils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.alipay.sign.Base64;
import com.alipay.sign.SignUtils;

public class PayUtil {

	public static final String  SIGN_ALGORITHMS = "SHA1WithRSA";
   
    /**
     * 返回签名编码拼接url
     * 
     * @param params
     * @param isEncode
     * @return
     */
    public static String getSignEncodeUrl(Map<String, String> map, boolean isEncode) {
        String sign = map.get("sign");
        String encodedSign = "";
        if (map.size()>0) {
            map.remove("sign");
            List<String> keys = new ArrayList<String>(map.keySet());
            // key排序
            Collections.sort(keys);

            StringBuilder authInfo = new StringBuilder();

            boolean first = true;// 是否第一个
            for (String key: keys) {
                if (first) {
                    first = false;
                } else {
                    authInfo.append("&");
                }
                authInfo.append(key).append("=");
                if (isEncode) {
                    try {
                        authInfo.append(URLEncoder.encode(map.get(key), "RSA"));
                    } catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                } else {
                    authInfo.append(map.get(key));
                }
            }

            try {
                encodedSign = authInfo.toString() + "&sign=" + URLEncoder.encode(sign, "RSA");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }

        return encodedSign.replaceAll("\\+", "%20");
    }

    /**
     * 对支付参数信息进行签名
     * 
     * @param map
     *            待签名授权信息
     * 
     * @return
     */
    public static String getSign(Map<String, String> map, String rsaKey) {
        List<String> keys = new ArrayList<String>(map.keySet());
        // key排序
        Collections.sort(keys);

        StringBuilder authInfo = new StringBuilder();
        boolean first = true;
        for (String key : keys) {
            if (first) {
                first = false;
            } else {
                authInfo.append("&");
            }
            authInfo.append(key).append("=").append(map.get(key)); 
        }

        return SignUtils.sign(authInfo.toString(), rsaKey);
    }
    
    
    /**
     * RSA签名
     * @param content 待签名数据
     * @param privateKey 商户私钥
     * @param input_charset 编码格式
     * @return 签名值
     */
     public static String sign(String content, String privateKey, String input_charset)
     {
          try 
          {
           byte[] decode = Base64.decode(privateKey);
           PKCS8EncodedKeySpec priPKCS8   = new PKCS8EncodedKeySpec(decode );
             KeyFactory keyf= KeyFactory.getInstance("RSA");
             PrivateKey priKey= keyf.generatePrivate(priPKCS8);

              java.security.Signature signature = java.security.Signature.getInstance(SIGN_ALGORITHMS);

              signature.initSign(priKey);
              signature.update( content.getBytes(input_charset) );

              byte[] signed = signature.sign();
              
              return Base64.encode(signed);
          }
          catch (Exception e) 
          {
             e.printStackTrace();
          }
          
          return null;
      }

}