package com.cku.restful.v1.handler.web;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.groomer.utils.GroomerUtil;
import com.cku.oa.groomer.vo.GroomerCertificatesH5VO;
import com.cku.oa.handler.entity.HandlerQualificationCertificate;
import com.cku.oa.handler.service.HandlerQualificationCertificateService;
import com.cku.oa.handler.vo.HandlerCertificatesH5VO;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.handler.vo.HandlerQualificationCertificateVO;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Hjx
 * 20250728
 */
@Controller
@RequestMapping(value = "/handler")
public class RestHandlerQualificationCertificateController {

    @Autowired
    private HandlerQualificationCertificateService handlerQualificationCertificateService;

    @Autowired
    private MemberDao memberDao;

    /**
     * 训练师资格证书列表1
     * @throws Exception
     * @Author hujiaxin
     * 20250728
     */
    @RequestMapping(value = "/trainerCertificates")
    @ResponseBody
    public ResultDto<HandlerCertificatesH5VO> handlerTrainerCertificates(
            @RequestParam(name = "id", required = false) String id,
            @RequestParam(name = "token", required = false) String token) throws Exception {
        HandlerCertificatesH5VO map = new HandlerCertificatesH5VO();
        List<HandlerQualificationCertificateVO> list = new ArrayList<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

        Member member = null;
        if (StringUtils.isBlank(token)) {
            throw new ZAException(ZAErrorCode.ZA_ERROR, "获取不到用户信息！");
        }
        member = UserUtils.getLoginMember();
        if (member != null) {
            map.setAvatar(GroomerUtil.getUrl(member.getAvatar()));
            map.setMemberName(member.getName());
            map.setMemberCode(member.getMemberCode());

            HandlerQualificationCertificate certificate = new HandlerQualificationCertificate();
            certificate.setMemberCode(member.getMemberCode());
            List<HandlerQualificationCertificate> lists = handlerQualificationCertificateService
                    .findTrainerListByCertificate(certificate);
            for (HandlerQualificationCertificate certificate1 : lists) {
                HandlerQualificationCertificateVO vo = new HandlerQualificationCertificateVO();
                BeanUtils.copyProperties(certificate1, vo);
                if (certificate1.getIssueDate() != null) {
                    vo.setIssueDate(certificate1.getIssueDate());
                }
                vo.setCertificateLevelCn(DictUtils.getDictLabel(vo.getCertificateLevelEn(), "handler_test_level", ""));
                list.add(vo);
            }
        }
        map.setList(list);
        return ResultDto.success(map);
    }

}
