/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.handler.vo;

import com.cku.oa.handler.entity.HandlerRegister;
import com.cku.oa.sys.entity.user.Member;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.util.Date;
import java.util.List;

/**
 * 资格证书Entity
 * @author 柴雪腾
 * @version 2016-08-08
 */

@Data
public class HandlerQualificationCertificateVO{

	private String id;   //id

	private String memberCode;		// 会员号

	private String name;  //导出专用

	private String gender;		// 导出专用性别

	private String registerId; //报名表id

	private Date takeCertificateDate;		// 取证日期

	private String certificateCode;		// 证书编号

	private String certificateLevelCn;		// 证书级别-cn
	private String certificateLevelEn;		// 证书级别-en
	private Date issueDate;		// 签发日期
	private String handlerRegisterId;		// 报名表id
	private String reviewer;		// 审查员
	private String printState;		// 打印状态
	private String reviewState;		// 审核状态
	private Date reviewTime;		// 审核时间
	private String paymentState;		// 付款的状态
	private Date paymentTime;		// 付款时间
	private String proccessState;		// 流程状态
	private Date proccessTime;		// 流程变更的时间
	private String runningNumber;		// 流水号
	private String reviewRemarks;		// 审核的意见
	private HandlerRegister handlerRegister; //报名表
	private Member member;

	private String taskDate;
	private String issDate;
	private String schoolNameCn;
	private List<String> level;

	private String avatarBase64;

	private String endFlag;

	private String certificateType;

}