package com.cku.restful.v1.express.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.PageResultDto;
import com.cku.core.ResultDto;
import com.cku.oa.sys.service.ExpressSendService;
import com.cku.restful.v1.express.vo.RestExpressRespVo;
import com.cku.restful.v1.express.vo.RestExpressRouteVo;
import com.thinkgem.jeesite.common.web.BaseController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(tags = "邮寄-zxy")
@Controller
@RequestMapping(value = "/api/v1/express")
public class RestExpressController extends BaseController {

	@Autowired
	private ExpressSendService expressSendService;

	@ApiOperation(value = "邮寄列表")
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ResponseBody
	public PageResultDto<RestExpressRespVo> getList(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		return expressSendService.restList(request, response);
	}

	@ApiOperation(value = "物流信息")
	@RequestMapping(value = "/route/{orderId}", method = RequestMethod.GET)
	@ResponseBody
	public ResultDto<RestExpressRouteVo> getMember(
			@ApiParam(name = "orderId", value = "orderId") @PathVariable String orderId, HttpServletResponse response)
			throws Exception {
		
		return ResultDto.success(expressSendService.restRoute(orderId));
	}

}
