package com.cku.restful.v1.dog.web;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogNewbornDao;
import com.cku.oa.dog.dao.DogPedigreeCertifiedExportDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogNewborn;
import com.cku.oa.dog.entity.DogPedigreeCertifiedExport;
import com.cku.oa.dog.entity.dogamphimixis.DogAmphimixisProve;
import com.cku.oa.dog.service.DogPedigreeCertifiedExportService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.dogamphimixis.DogAmphimixisProveService;
import com.cku.restful.v1.dog.vo.DogPedigreeCertifiedExportVo;
import com.cku.util.ChineseUtils;
import com.thinkgem.jeesite.common.servlet.ValidateCodeServlet;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.session.Session;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;

@RestController
@RequestMapping("/api/v1/export")
@Api(tags = "张向-出口证书查询")
public class CkuDogExportController {

    @Autowired
    private DogPedigreeCertifiedExportDao dogPedigreeCertifiedExportDao;

    @Autowired
    private DogDao dogDao;

    @Autowired
    private DogService dogService;

    @Autowired
    private DogNewbornDao dogNewbornDao;
    @Autowired
    private DogAmphimixisProveService dogAmphimixisProveService;

    @GetMapping("")
    @ApiOperation(value = "出口证书查询")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pedigreeCertified" ,value = "血统证书号", paramType = "query"),
            @ApiImplicitParam(name = "identificationFlag" ,value = "身份识别标记", paramType = "query"),
            @ApiImplicitParam(name = "validateCode" ,value = "验证码", paramType = "query"),
    })
    public RESTResponse query(HttpServletRequest request){
        RESTResponse restResponse = new RESTResponse();
        try {
            String pedigreeCertifiedCode = request.getParameter("pedigreeCertifiedCode");
            String identificationFlag = request.getParameter("identificationFlag");
            //验证码验证
            String validateCode = request.getParameter("validateCode");
            if (StringUtils.isBlank(validateCode)) {
                restResponse.setRc(-1);
//                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码为空");
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "The verification code is empty");
            }
            Session session = UserUtils.getSession();
            String code = (String) session.getAttribute(ValidateCodeServlet.VALIDATE_CODE);
            if (code == null) {
                restResponse.setRc(-1);
//                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码无效，请从新获取验证码");
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "The verification code is invalid, please obtain the verification code again");
            }
            if (!validateCode.toLowerCase().equals(code)) {
                // 重置验证码
                session.setAttribute(ValidateCodeServlet.VALIDATE_CODE, null);
                restResponse.setRc(-1);
//                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码有误");
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "Incorrect verification code");
            }
            // 重置验证码
            session.setAttribute(ValidateCodeServlet.VALIDATE_CODE, null);

            Dog dog = new Dog();
            dog.setPedigreeCertifiedCode(pedigreeCertifiedCode);
            dog.setIdentificationFlag(identificationFlag);
            Dog byDog = dogDao.getByDog(dog);
            if(byDog==null){
                restResponse.setRc(1001);
                throw new Exception("Not registered with CKU, please enter the correct certificate number and chip number");
            }

            DogPedigreeCertifiedExport export = new DogPedigreeCertifiedExport();
            export.setPedigreeCertified(pedigreeCertifiedCode);
            export.setIdentificationFlag(identificationFlag);
            DogPedigreeCertifiedExport byExport = dogPedigreeCertifiedExportDao.getByExport(export);
            if(byExport==null){
                restResponse.setRc(1002);
                throw new Exception("Registered with CKU, but no export record can be found");
            }
            DogPedigreeCertifiedExportVo vo = new DogPedigreeCertifiedExportVo();
            //组装数据
            BeanUtils.copyProperties(byExport,vo);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            vo.setBirthdate(byExport.getBirthdate()==null ? "":sdf.format(byExport.getBirthdate()));
            vo.setReviewTime(byExport.getReviewTime()==null ? "":sdf.format(byExport.getReviewTime()));
            vo.setPrintTime(byExport.getPrintTime()==null ? "":sdf.format(byExport.getPrintTime()));
            vo.setNameEn(byDog.getNameEn());
            vo.setGender(byDog.getGender().equals("1")?"male":"female");
            if (ChineseUtils.isContainChinese(byDog.getBreeder())) {
                vo.setBreeder(ChineseUtils.getFullSpell(byDog.getBreeder()));
            }else{
                vo.setBreeder(byDog.getBreeder());
            }
            vo.setDogOwner(byExport.getDogOwner());
            DogNewborn dogNewborn = dogNewbornDao.getByBreedCertifiedCode(byDog.getFmdogBreedCertifiedCode());
            if (dogNewborn != null) {
                vo.setPuppyBirthNum(replace(dogNewborn.getPuppyBirthNum().replace(" ", "")));
                vo.setPuppyRegisterNum(replace(dogNewborn.getPuppyRegisterNum().replace(" ", "")));
            } else {
                // 如果国内配种证明表找不到，去国外配种证明表找
                DogAmphimixisProve dogAmphimixisProve = dogAmphimixisProveService.getMsg(byDog.getFmdogBreedCertifiedCode());
                if (dogAmphimixisProve != null) {
                    String replace = dogAmphimixisProve.getNumberBirths().replace(" ", "");
                    String replace2 = dogAmphimixisProve.getNumberRegisteredDogs().replace(" ", "");
                    vo.setPuppyBirthNum(replace(replace));
                    vo.setPuppyRegisterNum(replace(replace2));
                }
            }
            return new RESTResponse("vo",vo);
        }catch (Exception e) {
            restResponse.setMsg(e.getMessage());
            return restResponse;
        }
    }
    public String replace(String str){
        if(StringUtils.isBlank(str)){
            return "";
        }
        String str1 = str.substring(0,1);
        String str2 = str.substring(2, 3);

        return "male "+str1+"  "+"female "+str2;
    }
}
