package com.cku.restful.v1.appreciation.model;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@ApiModel
@NoArgsConstructor
@AllArgsConstructor
public class RestAppreciationCourseware implements Serializable {

	private static final long serialVersionUID = -8606324525265916411L;

	@ApiModelProperty(value = "课件名称")
	private String coursewareName;

	@ApiModelProperty(value = "课件地址")
	private String coursewareUrl;

	@JsonFormat(pattern = "yyyy-MM-dd")
	@ApiModelProperty(value = "更新日期")
	private Date updateDate;
}
