package com.cku.partner.sys;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.service.UserService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.IPLimitUtil;
import com.cku.util.MD5Generator;
import com.cku.util.ServletUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thinkgem.jeesite.common.servlet.ValidateCodeServlet;
import com.thinkgem.jeesite.modules.sys.entity.Area;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.security.FormAuthenticationFilter;
import com.thinkgem.jeesite.modules.sys.security.UsernamePasswordToken;
import com.thinkgem.jeesite.modules.sys.service.SystemService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;

/**
 * 合作机构与合作医院的用户登录
 * @author fanhuibin
 *
 */
@Controller
@RequestMapping(value="/partner")
public class PartnerLoginController {
	@Autowired
	private SystemService systemService;
	@Autowired
	private OrgService orgService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private UserService userService;

	//合作机构与合作医院的用户退出
	@RequestMapping(value="/logout" , method=RequestMethod.GET)
	public String logout(HttpServletRequest request,HttpServletResponse response) throws IOException{
		try{
			SecurityUtils.getSubject().logout();
		}catch(Exception e){
			e.printStackTrace();
		}
		return "partner/sys/sysLogin";
		
		//return "redirect:http://www.cku.org.cn";
	}

	@RequestMapping(value = {"","/index"}, method = RequestMethod.GET)
	public String loginPage(){
		return "partner/sys/sysLogin";
	}

	//合作机构与合作医院的登录
	@RequestMapping(value = "/login", method = RequestMethod.POST)
	public String login(@RequestParam String username,@RequestParam String password,@RequestParam String validateCode,HttpServletRequest request,Model model){
		String host = IPLimitUtil.getIpAddr((HttpServletRequest)request);
		//获取登录端 by zhuoHeng 2017年4月20日11:41:36
		String loginType = ServletUtils.getParameter(request, "loginType",null);
		try{
			Org org = doLogin(username, password, validateCode, host,loginType);
			if(org.getOrgType().equals("club") || org.getOrgType().equals("chongjihemendian")
					|| org.getOrgType().equals("catRenZheng") || org.getOrgType().equals("singleTypeClub")){
				model.addAttribute("title","CKU 合作机构");
			}else{
				model.addAttribute("title","CKU 合作医院");
			}
			model.addAttribute("orgType",org.getOrgType());
			UserUtils.getSession().setAttribute("org", org);
			return "partner/sys/index";

		}catch(Exception e){
			model.addAttribute(FormAuthenticationFilter.DEFAULT_USERNAME_PARAM, username);
			model.addAttribute(FormAuthenticationFilter.DEFAULT_MESSAGE_PARAM, e.getMessage());
			return "partner/sys/sysLogin";
		}


	}

	//用户刷新页面
	@RequestMapping(value = "/login", method = RequestMethod.GET)
	public String getLogin(HttpServletRequest request,Model model){
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		if(org == null || !SecurityUtils.getSubject().isAuthenticated()){
			return "partner/sys/sysLogin";
		}

		if(org.getOrgType().equals("club") || org.getOrgType().equals("chongjihemendian")
				|| org.getOrgType().equals("catRenZheng") || org.getOrgType().equals("singleTypeClub")){
			model.addAttribute("title","CKU 合作机构");
		}else{
			model.addAttribute("title","CKU 合作医院");
		}
		model.addAttribute("orgType",org.getOrgType());
		return "partner/sys/index";
	}

	private Org doLogin(String username, String password, String validateCode,
			String host,String loginType) {
		if(StringUtils.isBlank(username)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录名不能为空");
		}
		if(StringUtils.isBlank(password)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "密码不能为空");
		}
		//验证码校验
		userService.checkValidateCode(validateCode);
		User user = systemService.getUserByLoginNameAndUserType(username,"3");
		if(user==null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录帐号不存在");
		}
		if(!user.getPassword().equals(MD5Generator.generate16(password))){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您输入的密码不正确");
		}
		//合作机构可不可用是判断合作机构的截止时间
		Org org = new Org();
		org.setUser(user);
		List<Org> orgs = orgService.findList(org);
		if(orgs.size() == 1){
			if(orgs.get(0).getEndDate().getTime()<System.currentTimeMillis()){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "对不起您的帐号已经过期，请联系CKU处理");
			}
		}else{
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "对不起您的帐号信息有误，请联系CKU处理");
		}

		//将用户信息存放到登录信息里
		UsernamePasswordToken token = new UsernamePasswordToken(username,password.toCharArray(),"3",false,host,validateCode,false,loginType);
		SecurityUtils.getSubject().login(token);

		return orgs.get(0);
	}

	/**
	 * 密码页
	 * @Author chaixueteng
	 * @2016年10月13日上午9:57:54
	 */
	@RequestMapping(value="/rePassword")
	public String rePassword(Model model){
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		User user = org.getUser();
		model.addAttribute("user", user);
		return "partner/sys/rePassword";
	}

	/**
	 * 修改密码
	 * @Author chaixueteng
	 * @2016年10月13日上午11:10:48
	 */
	@RequestMapping(value="/updatePassword")
	public String updatePassword(String oldPassword, String newPassword, Model model){
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		User user = org.getUser();
		if (StringUtils.isNotBlank(oldPassword) && StringUtils.isNotBlank(newPassword)){
			if (SystemService.validatePassword(oldPassword, user.getPassword())){
				orgService.updatePasswordById(user.getId(), newPassword);
				model.addAttribute("message", "修改密码成功");
			}else{
				model.addAttribute("message", "修改密码失败，旧密码错误");
			}
		}
		model.addAttribute("user", user);
		return "partner/sys/rePassword";
	}

	/**
	 *
	 * @description: 获取验证码
	 * @author: laiguanglong
	 * @date: 2016年9月26日 下午6:27:34
	 */
	@RequestMapping(value = "/validateCode", method = RequestMethod.GET)
	public void getHospital(HttpServletRequest request,
			HttpServletResponse response) throws IOException, ServletException {
		ValidateCodeServlet servlet = new ValidateCodeServlet();
		servlet.doGet(request, response);
	}

	@ResponseBody
	@RequestMapping(value = "treeData")
	public List<Map<String, Object>> treeData(@RequestParam(required=false) String extId, HttpServletResponse response) {
		List<Map<String, Object>> mapList = Lists.newArrayList();
		extId = URLDecoder.decode(extId);
		List<Area> list = UserUtils.getCityByProvince(extId);
		for (int i=0; i<list.size(); i++){
			Area e = list.get(i);
			Map<String, Object> map = Maps.newHashMap();
			map.put("id", e.getId());
			map.put("pId", e.getParentId());
			map.put("name", e.getName());
			mapList.add(map);
		}
		return mapList;
	}
}
