package com.cku.oa.sys.util;

import cn.jiguang.common.ClientConfig;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.Notification;
import com.thinkgem.jeesite.common.config.Global;

import java.util.Map;

public class JpushUtil {

    private static final String APP_KEY = Global.getConfig("JPUSH_APP_KEY");
    private static final String MASTER_SECRET = Global.getConfig("JPUSH_MASTER_SECRET");

    private static final boolean APNS_PRODUCTION = "product".equals(Global.getConfig("mode"));

    private static JPushClient jpushClient = new JPushClient(MASTER_SECRET, APP_KEY, null, ClientConfig.getInstance());

    public static void pushByMemberCode(String memberCode, String content, Map<String, String> extraMap) {
        PushPayload payload = androidIosPushByTag(memberCode, content, extraMap);
        try {
            jpushClient.sendPush(payload);
        } catch (Exception e) {
            System.out.println("推送失败");
        }
    }

    public static PushPayload androidIosPushByTag(String memberCode, String content, Map<String, String> extraMap) {
        Long currentTimeMillis = System.currentTimeMillis();
        IosNotification.Builder iosNotificationBuilder = IosNotification.newBuilder().setContentAvailable(true)
                .addExtra("currentTimeMillis", currentTimeMillis)
                .setSound("happy");
        AndroidNotification.Builder androidNotificationBuilder = AndroidNotification.newBuilder()
                .addExtra("currentTimeMillis", currentTimeMillis);
        for (Map.Entry<String, String> entry : extraMap.entrySet()) {
            iosNotificationBuilder.addExtra(entry.getKey(), entry.getValue());
            androidNotificationBuilder.addExtra(entry.getKey(), entry.getValue());
        }
        return PushPayload
                .newBuilder()
                .setPlatform(Platform.android_ios())
                .setAudience(Audience.tag(memberCode))
                .setNotification(
                        Notification
                                .newBuilder()
                                .setAlert(content)
                                .addPlatformNotification(
                                        iosNotificationBuilder.build())
                                .addPlatformNotification(
                                        androidNotificationBuilder.build())
                                .build())
                .setOptions(Options.newBuilder().setApnsProduction(APNS_PRODUCTION).build())
                .build();
    }
}
