package com.cku.oa.sys.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.sys.dao.OrgDao;
import com.cku.oa.sys.dao.OrgDogTypeLimitDao;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.OrgDogTypeLimit;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 俱乐部经营犬种Service
 * 
 * @author yuanshuai
 * @version 2019-10-16
 */
@Service
@Transactional(readOnly = true)
public class OrgDogTypeLimitService extends CrudService<OrgDogTypeLimitDao, OrgDogTypeLimit> {
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private OrgDao orgDao;
	@Autowired
	private MemberService memberService;

	public OrgDogTypeLimit get(String id) {
		return super.get(id);
	}

	public List<OrgDogTypeLimit> findList(OrgDogTypeLimit orgDogTypeLimit) {
		return super.findList(orgDogTypeLimit);
	}

	public Page<OrgDogTypeLimit> findPage(Page<OrgDogTypeLimit> page, OrgDogTypeLimit orgDogTypeLimit) {
		return super.findPage(page, orgDogTypeLimit);
	}

	@Transactional(readOnly = false)
	public void save(OrgDogTypeLimit orgDogTypeLimit) {
		super.save(orgDogTypeLimit);
	}

	@Transactional(readOnly = false)
	public void delete(OrgDogTypeLimit orgDogTypeLimit) {
		super.delete(orgDogTypeLimit);
	}

	public List<String> findTypeByOrgId(String orgId) {
		return dao.findTypeByOrgId(orgId);
	}

	public List<String> findTypeCnByOrgId(String orgId) {
		return dao.findTypeCnByOrgId(orgId);
	}

	/**
	 * 判断犬种是否为单犬种俱乐部
	 * 
	 * @param
	 * @param
	 * @return
	 */
	public void checkSingleTypeClub(String clubCode, String dogBreed, String memberCode,
			DogBirthCertificate dogBirthCertificate) {
		int i = 0;
		Org org = orgDao.get(clubCode);
		if (org == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该俱乐部信息有误。");
		}
		// 如果为单犬种俱乐部
		if (org.getOrgType().equals("singleTypeClub")) {
			DogType dogType = dogTypeService.getByDogBreedCode(dogBreed);
			if (dogType == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只种类不存在。");
			}
			List<String> originalList = this.findTypeByOrgId(org.getId());
			for (String orgLimit : originalList) {
				if (StringUtils.isNotBlank(orgLimit) && orgLimit.equals(dogType.getId())) {
					i = i + 1;
					break;
				}
			}
			if (i == 0) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "此俱乐部为单犬种俱乐部，您申请的犬只无法在此俱乐部进行办理。");
			}

			if (dogBirthCertificate == null) {
				if (!memberCode.equals(org.getAdminCode())) {
					Member singleMember = memberService.singleMember(memberCode, org.getUser().getLoginName());
					if (singleMember == null) {
						throw new ZAException(ZAErrorCode.ZA_ERROR, "不是该单犬种俱乐部名下登记会员，无法在该机构办理业务");
					}
				}
			} else {
				// 繁殖人
				Member breederMember = memberService.singleMember(dogBirthCertificate.getBreederMemberCode(),
						org.getUser().getLoginName());
				// 新犬主
				Member singleMember = memberService.singleMember(memberCode, org.getUser().getLoginName());
				if (!(breederMember != null
						|| (StringUtils.isBlank(dogBirthCertificate.getBreederMemberCode()) ? ""
								: dogBirthCertificate.getBreederMemberCode()).equals(org.getAdminCode())
						|| singleMember != null || memberCode.equals(org.getAdminCode()))) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "不是该单犬种俱乐部名下登记会员，无法在该机构办理业务");
				}
			}

		}

	}

	public void checkSingleTypeClub(String clubCode, String dogBreed) {
		int i = 0;
		Org org = orgDao.get(clubCode);
		if (org == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该俱乐部信息有误。");
		}
		// 如果为单犬种俱乐部
		if (org.getOrgType().equals("singleTypeClub")) {
			DogType dogType = dogTypeService.getByDogBreedCode(dogBreed);
			if (dogType == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只种类不存在。");
			}
			List<String> originalList = this.findTypeByOrgId(org.getId());
			for (String orgLimit : originalList) {
				if (StringUtils.isNotBlank(orgLimit) && orgLimit.equals(dogType.getId())) {
					i = i + 1;
					break;
				}
			}
			if (i == 0) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "此俱乐部为单犬种俱乐部，您申请的犬只无法在此俱乐部进行办理。");
			}
		}
	}
	
	public void checkSingleTypeClubNew(String clubCode, String dogBreed) {
		int i = 0;
		Org org = orgDao.get(clubCode);
		if (org == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该俱乐部信息有误。");
		}

		if ("2".equals(org.getOrgSite())) {
			if (!"15C".equals(dogBreed)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您申请的犬只无法在此俱乐部进行办理。");
			}
		}
		// 如果为单犬种俱乐部
		if (org.getOrgType().equals("singleTypeClub")) {
			DogType dogType = dogTypeService.getByDogBreedCode(dogBreed);
			if (dogType == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只种类不存在。");
			}
			List<String> originalList = this.findTypeByOrgId(org.getId());
			for (String orgLimit : originalList) {
				if (StringUtils.isNotBlank(orgLimit) && orgLimit.equals(dogType.getId())) {
					i = i + 1;
					break;
				}
			}
			if (i == 0) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "此俱乐部为单犬种俱乐部，您申请的犬只无法在此俱乐部进行办理。");
			}
		}
	}

	/**
	 * @Description： 单犬种俱乐部校验犬种是否有效
	 * 
	 * @author: yuanshuai
	 * @date: 2019/10/21 10:36
	 */
	public boolean checkSingleOrgDogTypeId(String orgId, String dogTypeId) {
		return dao.checkSingleOrgDogType(orgId, dogTypeId) > 0;
	}

	/**
	 * @Description： 单犬种俱乐部校验犬种是否有效
	 * 
	 * @author: yuanshuai
	 * @date: 2019/10/21 10:36
	 * @return true为校验成功，false为校验失败
	 */
	public boolean checkSingleOrgDogTypeCode(String orgId, String dogTypeCode) {
		DogType dogType = dogTypeService.getByDogBreedCode(dogTypeCode);
		return dao.checkSingleOrgDogType(orgId, dogType.getId()) > 0;
	}
}