package com.cku.oa.statistics.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.statistics.dao.MemberInfoDao;
import com.cku.oa.statistics.entity.MemberInfo;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 *user chaixueteng
 *2017年1月16日
 */
@Service
@Transactional(readOnly = true)
public class MemberInfoService extends CrudService<MemberInfoDao, MemberInfo> {
	@Autowired
	private MemberInfoDao memberInfoDao;
	
	public Page<MemberInfo> findPage(Page<MemberInfo> page, MemberInfo memberInfo) {
		memberInfo.setPage(page);
		return page.setList(memberInfoDao.countByMember(memberInfo));
	}
}
