/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sfexpress.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 顺丰Entity
 * @author zhaoxy
 * @version 2019-08-30
 */
public class SfExpressState extends DataEntity<SfExpressState> {
	
	/**
	 *  04	调度失败/等待
		04-40001	调度成功+收派员信息
		04-40037	下单已接收
		04-40002-40021	电话号码异常(电话错误/空号/停机)
		04-40002-40022	无法进入客户处,且客户不愿出来
		04-40002-40004	暂未联系上客户(电话无人接听/无法接通/关机)
		04-40002-40005	经客户同意,更改收派时间
		04-40002-40027	天气原因,延误收派件
		04-40002-40028	交通原因,延误收派件
		04-40002-40031	不符合收件要求,无法揽收
		04-40002-40014	客户取消寄件
		04-40002-40015	客户重复下单
		04-40002-40016	下错单需转单
		04-40002-40035	工作量过大,延误收派件
		04-40002-40036	重货需转单
		00-40045-1000	调度取消订单
		00-2000	客户已取消订单
		05-40003	已正常收件状态
	 */
	
	private static final long serialVersionUID = 1L;
	private String orderNo;		// 客户订单号客户订单号
	private String waybillNo;		// 顺丰运单号顺丰运单号
	private String orderStateDesc;		// 订单状态
	private String orderStateCode;		// 订单状态描述
	private String empcode;		// 收件员工工号
	private String empphone;		// 收件员工手机号
	private String netcode;		// 网店
	private Date lasttime;		// 最晚上门时间
	private Date booktime;		// 客户预约时间
	private String carriercode;		// 承运商代码(SF)承运商代码(SF)
	private Date createTime; // 创建时间
	
	private String origincode;//原寄地区域代码,可用于顺丰电子面单标签打印。

	private String destcode;//目的地区域代码,可用于
	private String twoDimensionCode; // 中转二维码
	
	private String printIcon;
	private String proCode;
	private String destRouteLabel;
	private String codingMapping;
	private String destTeamCode;
	
	public String getDestRouteLabel() {
		return destRouteLabel;
	}

	public void setDestRouteLabel(String destRouteLabel) {
		this.destRouteLabel = destRouteLabel;
	}

	public String getCodingMapping() {
		return codingMapping;
	}

	public void setCodingMapping(String codingMapping) {
		this.codingMapping = codingMapping;
	}

	public String getDestTeamCode() {
		return destTeamCode;
	}

	public void setDestTeamCode(String destTeamCode) {
		this.destTeamCode = destTeamCode;
	}

	public String getPrintIcon() {
		return printIcon;
	}

	public void setPrintIcon(String printIcon) {
		this.printIcon = printIcon;
	}

	public String getProCode() {
		return proCode;
	}

	public void setProCode(String proCode) {
		this.proCode = proCode;
	}

	public SfExpressState() {
		super();
	}

	public SfExpressState(String id){
		super(id);
	}

	@Length(min=0, max=64, message="客户订单号客户订单号长度必须介于 0 和 64 之间")
	public String getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}
	
	@Length(min=0, max=64, message="顺丰运单号顺丰运单号长度必须介于 0 和 64 之间")
	public String getWaybillNo() {
		return waybillNo;
	}

	public void setWaybillNo(String waybillNo) {
		this.waybillNo = waybillNo;
	}
	
	@Length(min=0, max=20, message="订单状态长度必须介于 0 和 20 之间")
	public String getOrderStateCode() {
		return orderStateCode;
	}

	public void setOrderStateCode(String orderStateCode) {
		this.orderStateCode = orderStateCode;
	}

	@Length(min=0, max=200, message="订单状态描述长度必须介于 0 和 200 之间")
	public String getOrderStateDesc() {
		return orderStateDesc;
	}

	public void setOrderStateDesc(String orderStateDesc) {
		this.orderStateDesc = orderStateDesc;
	}

	@Length(min=0, max=100, message="收件员工工号长度必须介于 0 和 100 之间")
	public String getEmpcode() {
		return empcode;
	}

	public void setEmpcode(String empcode) {
		this.empcode = empcode;
	}
	
	@Length(min=0, max=100, message="收件员工手机号长度必须介于 0 和 100 之间")
	public String getEmpphone() {
		return empphone;
	}

	public void setEmpphone(String empphone) {
		this.empphone = empphone;
	}
	
	@Length(min=0, max=20, message="网店长度必须介于 0 和 20 之间")
	public String getNetcode() {
		return netcode;
	}

	public void setNetcode(String netcode) {
		this.netcode = netcode;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getLasttime() {
		return lasttime;
	}

	public void setLasttime(Date lasttime) {
		this.lasttime = lasttime;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getBooktime() {
		return booktime;
	}

	public void setBooktime(Date booktime) {
		this.booktime = booktime;
	}
	
	@Length(min=0, max=10, message="承运商代码(SF)承运商代码(SF)长度必须介于 0 和 10 之间")
	public String getCarriercode() {
		return carriercode;
	}

	public void setCarriercode(String carriercode) {
		this.carriercode = carriercode;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getOrigincode() {
		return origincode;
	}

	public void setOrigincode(String origincode) {
		this.origincode = origincode;
	}

	public String getDestcode() {
		return destcode;
	}

	public void setDestcode(String destcode) {
		this.destcode = destcode;
	}

	public String getTwoDimensionCode() {
		return twoDimensionCode;
	}

	public void setTwoDimensionCode(String twoDimensionCode) {
		this.twoDimensionCode = twoDimensionCode;
	}
	
	
	
}