package com.cku.oa.sampling.vo;

import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 导出采样包犬只Entity
 *
 * @author yuanshuai
 * @version 2023-05-22
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel
public class SamplingDogExportVo implements Serializable {

	private static final long serialVersionUID = -7018206085050256988L;

	@ExcelField(title = "采样包编号", align = 2, sort = 1)
	@ApiModelProperty("采样包编号")
	private String samplingCode;

	@ExcelField(title = "芯片号", align = 2, sort = 2)
	@ApiModelProperty("芯片号")
	private String chipNo;

	@ExcelField(title = "宠物类型", align = 2, sort = 3)
	@ApiModelProperty("宠物类型（犬）")
	private String petType;

	@ExcelField(title = "宠物性别", align = 2, sort = 4)
	@ApiModelProperty("宠物性别（1公2母）")
	private String gender;

	@ExcelField(title = "宠物品种", align = 2, sort = 5)
	@ApiModelProperty("宠物品种")
	private String breedCode;

	@ExcelField(title = "生日", align = 2, sort = 6)
	@ApiModelProperty("生日")
	private Date birthdate;

	@ExcelField(title = "宠物昵称", align = 2, sort = 7)
	@ApiModelProperty("宠物昵称")
	private String nickname;







}